@include('admin.header')

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Final Shipment Update - {{ $shipment->shipment_number }}</h4>
                <a href="{{ route('admin.shipments.final-shipments.index', $shipment) }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to Updates
                </a>
            </div>

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Final Shipment Update</h5>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.shipments.final-shipments.store', $shipment) }}" method="POST">
                                @csrf
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="original_quantity" class="form-label">Original Quantity *</label>
                                            <input type="number" name="original_quantity" id="original_quantity" 
                                                   class="form-control" value="{{ $originalQuantity }}" 
                                                   min="0" readonly>
                                            <small class="form-text text-muted">Auto-filled from shipment cartons</small>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="adjusted_quantity" class="form-label">Adjusted Quantity *</label>
                                            <input type="number" name="adjusted_quantity" id="adjusted_quantity" 
                                                   class="form-control" value="{{ old('adjusted_quantity', 0) }}" 
                                                   required>
                                            <small class="form-text text-muted">Use positive (+) for increase, negative (-) for decrease</small>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="final_shipment_date" class="form-label">Final Shipment Date *</label>
                                            <input type="date" name="final_shipment_date" id="final_shipment_date" 
                                                   class="form-control" value="{{ old('final_shipment_date', date('Y-m-d')) }}" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="adjustment_reason" class="form-label">Adjustment Reason *</label>
                                    <textarea name="adjustment_reason" id="adjustment_reason" class="form-control" rows="3" 
                                              placeholder="Reason for quantity adjustment..." required>{{ old('adjustment_reason') }}</textarea>
                                </div>

                                <div class="mb-3">
                                    <label for="inspection_remarks" class="form-label">Inspection Remarks</label>
                                    <textarea name="inspection_remarks" id="inspection_remarks" class="form-control" rows="3" 
                                              placeholder="Post-inspection remarks...">{{ old('inspection_remarks') }}</textarea>
                                </div>

                                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                    <button type="reset" class="btn btn-secondary">Reset</button>
                                    <button type="submit" class="btn btn-primary">Create Final Update</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Quantity Preview</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Original Quantity:</strong><br>
                                <span id="original-qty-preview" class="fw-bold">{{ number_format($originalQuantity) }}</span>
                            </div>
                            <div class="mb-3">
                                <strong>Adjusted Quantity:</strong><br>
                                <span id="adjusted-qty-preview" class="fw-bold">0</span>
                            </div>
                            <div class="mb-3">
                                <strong>Final Quantity:</strong><br>
                                <span id="final-qty-preview" class="fw-bold text-success">{{ number_format($originalQuantity) }}</span>
                            </div>
                            <div class="mb-3">
                                <strong>Adjustment Type:</strong><br>
                                <span id="adjustment-type-preview" class="badge bg-secondary">No Change</span>
                            </div>
                        </div>
                    </div>

                    <div class="card mt-3">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Shipment Info</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Shipment:</strong><br>
                                {{ $shipment->shipment_number }}
                            </div>
                            <div class="mb-3">
                                <strong>Order:</strong><br>
                                {{ $shipment->orderConfirmation->order_number }}
                            </div>
                            <div class="mb-3">
                                <strong>Total Cartons:</strong><br>
                                {{ $shipment->total_cartons }}
                            </div>
                            <div class="mb-3">
                                <strong>Current Status:</strong><br>
                                <span class="badge bg-{{ $shipment->status_badge_color }}">
                                    {{ ucfirst($shipment->status) }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Calculate final quantity and adjustment type
function calculateFinalQuantity() {
    const original = parseInt(document.getElementById('original_quantity').value) || 0;
    const adjusted = parseInt(document.getElementById('adjusted_quantity').value) || 0;
    const final = original + adjusted;
    
    document.getElementById('adjusted-qty-preview').textContent = adjusted >= 0 ? '+' + adjusted : adjusted;
    document.getElementById('final-qty-preview').textContent = final.toLocaleString();
    
    const adjustmentType = document.getElementById('adjustment-type-preview');
    if (adjusted > 0) {
        adjustmentType.className = 'badge bg-success';
        adjustmentType.textContent = 'Increase';
    } else if (adjusted < 0) {
        adjustmentType.className = 'badge bg-danger';
        adjustmentType.textContent = 'Decrease';
    } else {
        adjustmentType.className = 'badge bg-secondary';
        adjustmentType.textContent = 'No Change';
    }
}

// Event listener
document.getElementById('adjusted_quantity').addEventListener('input', calculateFinalQuantity);

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    calculateFinalQuantity();
});
</script>

@include('admin.footer')