@include('admin.header')

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Edit Carton - {{ $shipment->shipment_number }}</h4>
                <a href="{{ route('admin.shipments.carton-details.index', $shipment) }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to Cartons
                </a>
            </div>

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Edit Carton Details</h5>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.shipments.carton-details.update', [$shipment, $cartonDetail]) }}" method="POST">
                                @csrf
                                @method('PUT')
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="carton_number" class="form-label">Carton Number *</label>
                                            <input type="text" name="carton_number" id="carton_number" 
                                                   class="form-control" value="{{ old('carton_number', $cartonDetail->carton_number) }}" required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="quantity" class="form-label">Quantity *</label>
                                            <input type="number" name="quantity" id="quantity" 
                                                   class="form-control" value="{{ old('quantity', $cartonDetail->quantity) }}" 
                                                   min="1" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="gross_weight" class="form-label">Gross Weight (kg)</label>
                                            <input type="number" step="0.01" name="gross_weight" id="gross_weight" 
                                                   class="form-control" value="{{ old('gross_weight', $cartonDetail->gross_weight) }}">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="net_weight" class="form-label">Net Weight (kg)</label>
                                            <input type="number" step="0.01" name="net_weight" id="net_weight" 
                                                   class="form-control" value="{{ old('net_weight', $cartonDetail->net_weight) }}">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="volume" class="form-label">Volume (m³)</label>
                                            <input type="number" step="0.001" name="volume" id="volume" 
                                                   class="form-control" value="{{ old('volume', $cartonDetail->volume) }}">
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea name="description" id="description" class="form-control" rows="3">{{ old('description', $cartonDetail->description) }}</textarea>
                                </div>

                                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                    <a href="{{ route('admin.shipments.carton-details.index', $shipment) }}" class="btn btn-secondary me-2">Cancel</a>
                                    <button type="submit" class="btn btn-primary">Update Carton</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Carton Info</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Shipment:</strong><br>
                                {{ $shipment->shipment_number }}
                            </div>
                            <div class="mb-3">
                                <strong>Current Carton No:</strong><br>
                                {{ $cartonDetail->carton_number }}
                            </div>
                            <div class="mb-3">
                                <strong>Created At:</strong><br>
                                {{ $cartonDetail->created_at->format('M d, Y H:i') }}
                            </div>
                            <div class="mb-3">
                                <strong>Last Updated:</strong><br>
                                {{ $cartonDetail->updated_at->format('M d, Y H:i') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.footer')