@include('admin.header')

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Booking Invoice Details</h4>
                <div>
                    <a href="{{ route('admin.shipments.booking-invoices.index', $shipment) }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Back to Invoices
                    </a>
                    <a href="{{ route('admin.shipments.booking-invoices.edit', [$shipment, $bookingInvoice]) }}" class="btn btn-warning">
                        <i class="fas fa-edit me-1"></i> Edit
                    </a>
                </div>
            </div>

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Invoice Details</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">Invoice Number</th>
                                            <td>{{ $bookingInvoice->invoice_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>Shipment</th>
                                            <td>{{ $shipment->shipment_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>Order Confirmation</th>
                                            <td>{{ $shipment->orderConfirmation->order_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>Invoice Date</th>
                                            <td>{{ $bookingInvoice->invoice_date->format('M d, Y') }}</td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">Freight Charges</th>
                                            <td class="text-success">${{ number_format($bookingInvoice->freight_charges, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>Insurance Charges</th>
                                            <td>${{ number_format($bookingInvoice->insurance_charges, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>Handling Charges</th>
                                            <td>${{ number_format($bookingInvoice->handling_charges, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>Other Charges</th>
                                            <td>${{ number_format($bookingInvoice->other_charges, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>Total Charges</th>
                                            <td class="fw-bold text-success">${{ number_format($bookingInvoice->total_charges, 2) }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            @if($bookingInvoice->charges_description)
                            <div class="row mt-3">
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Charges Description</label>
                                        <div class="border p-3 bg-light rounded">
                                            {{ $bookingInvoice->charges_description }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Shipment Information</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Vessel/Flight:</strong><br>
                                {{ $shipment->vessel_flight_no ?? 'N/A' }}
                            </div>
                            <div class="mb-3">
                                <strong>Port of Loading:</strong><br>
                                {{ $shipment->port_of_loading ?? 'N/A' }}
                            </div>
                            <div class="mb-3">
                                <strong>Port of Discharge:</strong><br>
                                {{ $shipment->port_of_discharge ?? 'N/A' }}
                            </div>
                            <div class="mb-3">
                                <strong>ETD:</strong><br>
                                {{ $shipment->etd ? $shipment->etd->format('M d, Y') : 'N/A' }}
                            </div>
                            <div class="mb-3">
                                <strong>ETA:</strong><br>
                                {{ $shipment->eta ? $shipment->eta->format('M d, Y') : 'N/A' }}
                            </div>
                            <div class="mb-3">
                                <a href="{{ route('admin.shipments.booking-invoices.export-pdf', [$shipment, $bookingInvoice]) }}" 
   class="btn btn-sm btn-info" target="_blank">
    <i class="fas fa-file-pdf"></i> Download Invoice
</a>
                            </div>
                        </div>
                    </div>

                    <div class="card mt-3">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Invoice Info</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Created By:</strong><br>
                                {{ $bookingInvoice->creator->name }}
                            </div>
                            <div class="mb-3">
                                <strong>Created At:</strong><br>
                                {{ $bookingInvoice->created_at->format('M d, Y H:i') }}
                            </div>
                            <div class="mb-3">
                                <strong>Last Updated:</strong><br>
                                {{ $bookingInvoice->updated_at->format('M d, Y H:i') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.footer')