@include('admin.header')

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Booking Invoices - {{ $shipment->shipment_number }}</h4>
                <div>
                    <a href="{{ route('admin.shipments.show', $shipment) }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Back to Shipment
                    </a>
                    <a href="{{ route('admin.shipments.booking-invoices.create', $shipment) }}" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i> Create Invoice
                    </a>
                </div>
            </div>

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Booking Invoices</h5>
                </div>
                <div class="card-body">
                    @if($invoices->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Invoice No</th>
                                    <th>Invoice Date</th>
                                    <th>Freight Charges</th>
                                    <th>Insurance Charges</th>
                                    <th>Total Charges</th>
                                    <th>Description</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($invoices as $invoice)
                                <tr>
                                    <td>{{ $invoice->invoice_number }}</td>
                                    <td>{{ $invoice->invoice_date->format('M d, Y') }}</td>
                                    <td>${{ number_format($invoice->freight_charges, 2) }}</td>
                                    <td>${{ number_format($invoice->insurance_charges, 2) }}</td>
                                    <td class="fw-bold text-success">${{ number_format($invoice->total_charges, 2) }}</td>
                                    <td>{{ Str::limit($invoice->charges_description, 50) }}</td>
                                    <td class="table-actions">
                                        <a href="{{ route('admin.shipments.booking-invoices.show', [$shipment, $invoice]) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.shipments.booking-invoices.edit', [$shipment, $invoice]) }}" class="btn btn-sm btn-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.shipments.booking-invoices.destroy', [$shipment, $invoice]) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="table-dark">
                                    <th colspan="2">Total</th>
                                    <th>${{ number_format($invoices->sum('freight_charges'), 2) }}</th>
                                    <th>${{ number_format($invoices->sum('insurance_charges'), 2) }}</th>
                                    <th>${{ number_format($invoices->sum('total_charges'), 2) }}</th>
                                    <th colspan="2"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    @else
                    <div class="text-center text-muted py-4">
                        <i class="fas fa-file-invoice fa-3x mb-3"></i>
                        <p>No booking invoices created yet.</p>
                        <a href="{{ route('admin.shipments.booking-invoices.create', $shipment) }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Create First Invoice
                        </a>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.footer')