<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Booking Invoice - {{ $bookingInvoice->invoice_number }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 2px solid #333; padding-bottom: 20px; }
        .company-name { font-size: 24px; font-weight: bold; margin-bottom: 5px; }
        .invoice-title { font-size: 20px; margin: 20px 0; }
        .details-table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        .details-table td { padding: 8px; border: 1px solid #ddd; }
        .details-table .label { font-weight: bold; background: #f8f9fa; width: 30%; }
        .amount-table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        .amount-table th, .amount-table td { padding: 10px; border: 1px solid #333; text-align: right; }
        .amount-table th { background: #333; color: white; text-align: left; }
        .footer { margin-top: 50px; padding-top: 20px; border-top: 1px solid #ddd; }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name">Textile Export Company</div>
        <div>Shipping Department</div>
    </div>

    <div class="invoice-title">BOOKING INVOICE</div>

    <table class="details-table">
        <tr>
            <td class="label">Invoice Number:</td>
            <td>{{ $bookingInvoice->invoice_number }}</td>
            <td class="label">Invoice Date:</td>
            <td>{{ $bookingInvoice->invoice_date->format('d/m/Y') }}</td>
        </tr>
        <tr>
            <td class="label">Shipment Number:</td>
            <td>{{ $shipment->shipment_number }}</td>
            <td class="label">Order Number:</td>
            <td>{{ $shipment->orderConfirmation->order_number }}</td>
        </tr>
    </table>

    <table class="amount-table">
        <thead>
            <tr>
                <th>Description</th>
                <th>Amount ($)</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>Freight Charges</td>
                <td>{{ number_format($bookingInvoice->freight_charges, 2) }}</td>
            </tr>
            <tr>
                <td>Insurance Charges</td>
                <td>{{ number_format($bookingInvoice->insurance_charges, 2) }}</td>
            </tr>
            <tr>
                <td>Handling Charges</td>
                <td>{{ number_format($bookingInvoice->handling_charges, 2) }}</td>
            </tr>
            <tr>
                <td>Other Charges</td>
                <td>{{ number_format($bookingInvoice->other_charges, 2) }}</td>
            </tr>
            <tr style="font-weight: bold;">
                <td>TOTAL CHARGES</td>
                <td>{{ number_format($bookingInvoice->total_charges, 2) }}</td>
            </tr>
        </tbody>
    </table>

    @if($bookingInvoice->charges_description)
    <div style="margin: 20px 0;">
        <strong>Charges Description:</strong><br>
        {{ $bookingInvoice->charges_description }}
    </div>
    @endif

    <div class="footer">
        <div style="text-align: center;">
            <div style="border-top: 1px solid #333; width: 200px; margin: 0 auto 5px;"></div>
            <div>Authorized Signature</div>
        </div>
    </div>
</body>
</html>