@include('admin.header')

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Edit Booking Invoice - {{ $shipment->shipment_number }}</h4>
                <a href="{{ route('admin.shipments.booking-invoices.index', $shipment) }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to Invoices
                </a>
            </div>

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Edit Booking Invoice</h5>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.shipments.booking-invoices.update', [$shipment, $bookingInvoice]) }}" method="POST">
                                @csrf
                                @method('PUT')
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="invoice_date" class="form-label">Invoice Date *</label>
                                            <input type="date" name="invoice_date" id="invoice_date" 
                                                   class="form-control" value="{{ old('invoice_date', $bookingInvoice->invoice_date->format('Y-m-d')) }}" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="freight_charges" class="form-label">Freight Charges ($) *</label>
                                            <input type="number" step="0.01" name="freight_charges" id="freight_charges" 
                                                   class="form-control" value="{{ old('freight_charges', $bookingInvoice->freight_charges) }}" required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="insurance_charges" class="form-label">Insurance Charges ($)</label>
                                            <input type="number" step="0.01" name="insurance_charges" id="insurance_charges" 
                                                   class="form-control" value="{{ old('insurance_charges', $bookingInvoice->insurance_charges) }}">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="handling_charges" class="form-label">Handling Charges ($)</label>
                                            <input type="number" step="0.01" name="handling_charges" id="handling_charges" 
                                                   class="form-control" value="{{ old('handling_charges', $bookingInvoice->handling_charges) }}">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="other_charges" class="form-label">Other Charges ($)</label>
                                            <input type="number" step="0.01" name="other_charges" id="other_charges" 
                                                   class="form-control" value="{{ old('other_charges', $bookingInvoice->other_charges) }}">
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="charges_description" class="form-label">Charges Description</label>
                                    <textarea name="charges_description" id="charges_description" class="form-control" rows="3">{{ old('charges_description', $bookingInvoice->charges_description) }}</textarea>
                                </div>

                                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                    <a href="{{ route('admin.shipments.booking-invoices.index', $shipment) }}" class="btn btn-secondary me-2">Cancel</a>
                                    <button type="submit" class="btn btn-primary">Update Invoice</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Invoice Summary</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Invoice Number:</strong><br>
                                {{ $bookingInvoice->invoice_number }}
                            </div>
                            <div class="mb-3">
                                <strong>Current Total:</strong><br>
                                <span class="fw-bold text-success">${{ number_format($bookingInvoice->total_charges, 2) }}</span>
                            </div>
                            <div class="mb-3">
                                <strong>New Total:</strong><br>
                                <span id="new-total-preview" class="fw-bold text-primary">$0.00</span>
                            </div>
                            <div class="mb-3">
                                <strong>Created By:</strong><br>
                                {{ $bookingInvoice->creator->name }}
                            </div>
                            <div class="mb-3">
                                <strong>Created At:</strong><br>
                                {{ $bookingInvoice->created_at->format('M d, Y H:i') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Calculate total charges
function calculateTotal() {
    const freight = parseFloat(document.getElementById('freight_charges').value) || 0;
    const insurance = parseFloat(document.getElementById('insurance_charges').value) || 0;
    const handling = parseFloat(document.getElementById('handling_charges').value) || 0;
    const other = parseFloat(document.getElementById('other_charges').value) || 0;
    const total = freight + insurance + handling + other;
    document.getElementById('new-total-preview').textContent = '$' + total.toFixed(2);
}

// Event listeners
document.getElementById('freight_charges').addEventListener('input', calculateTotal);
document.getElementById('insurance_charges').addEventListener('input', calculateTotal);
document.getElementById('handling_charges').addEventListener('input', calculateTotal);
document.getElementById('other_charges').addEventListener('input', calculateTotal);

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    calculateTotal();
});
</script>


@include('admin.footer')