@include('admin.header')

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Create Booking Invoice - {{ $shipment->shipment_number }}</h4>
                <a href="{{ route('admin.shipments.booking-invoices.index', $shipment) }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to Invoices
                </a>
            </div>

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Create Booking Invoice</h5>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.shipments.booking-invoices.store', $shipment) }}" method="POST">
                                @csrf
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="invoice_date" class="form-label">Invoice Date *</label>
                                            <input type="date" name="invoice_date" id="invoice_date" 
                                                   class="form-control" value="{{ old('invoice_date', date('Y-m-d')) }}" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="freight_charges" class="form-label">Freight Charges ($) *</label>
                                            <input type="number" step="0.01" name="freight_charges" id="freight_charges" 
                                                   class="form-control" value="{{ old('freight_charges', 0) }}" 
                                                   min="0" required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="insurance_charges" class="form-label">Insurance Charges ($)</label>
                                            <input type="number" step="0.01" name="insurance_charges" id="insurance_charges" 
                                                   class="form-control" value="{{ old('insurance_charges', 0) }}" 
                                                   min="0">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="handling_charges" class="form-label">Handling Charges ($)</label>
                                            <input type="number" step="0.01" name="handling_charges" id="handling_charges" 
                                                   class="form-control" value="{{ old('handling_charges', 0) }}" 
                                                   min="0">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="other_charges" class="form-label">Other Charges ($)</label>
                                            <input type="number" step="0.01" name="other_charges" id="other_charges" 
                                                   class="form-control" value="{{ old('other_charges', 0) }}" 
                                                   min="0">
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="charges_description" class="form-label">Charges Description</label>
                                    <textarea name="charges_description" id="charges_description" class="form-control" rows="3" 
                                              placeholder="Description of charges...">{{ old('charges_description') }}</textarea>
                                </div>

                                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                    <button type="reset" class="btn btn-secondary">Reset</button>
                                    <button type="submit" class="btn btn-primary">Create Invoice</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Invoice Preview</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Invoice Number:</strong><br>
                                <span class="text-muted">Auto-generated</span>
                            </div>
                            <div class="mb-3">
                                <strong>Total Charges:</strong><br>
                                <span id="total-charges-preview" class="fw-bold text-success">$0.00</span>
                            </div>
                        </div>
                    </div>

                    <div class="card mt-3">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Shipment Info</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Shipment:</strong><br>
                                {{ $shipment->shipment_number }}
                            </div>
                            <div class="mb-3">
                                <strong>Order:</strong><br>
                                {{ $shipment->orderConfirmation->order_number }}
                            </div>
                            <div class="mb-3">
                                <strong>Total Cartons:</strong><br>
                                {{ $shipment->total_cartons }}
                            </div>
                            <div class="mb-3">
                                <strong>Total Quantity:</strong><br>
                                {{ number_format($shipment->total_quantity) }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Calculate total charges
function calculateTotal() {
    const freight = parseFloat(document.getElementById('freight_charges').value) || 0;
    const insurance = parseFloat(document.getElementById('insurance_charges').value) || 0;
    const handling = parseFloat(document.getElementById('handling_charges').value) || 0;
    const other = parseFloat(document.getElementById('other_charges').value) || 0;
    const total = freight + insurance + handling + other;
    document.getElementById('total-charges-preview').textContent = '$' + total.toFixed(2);
}

// Event listeners
document.getElementById('freight_charges').addEventListener('input', calculateTotal);
document.getElementById('insurance_charges').addEventListener('input', calculateTotal);
document.getElementById('handling_charges').addEventListener('input', calculateTotal);
document.getElementById('other_charges').addEventListener('input', calculateTotal);

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    calculateTotal();
});
</script>

@include('admin.footer')