@include('admin.header')

<div class="container my-4">
    <div class="card shadow-lg rounded-3">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0 text-white">Company Details</h3>
        </div>
        <div class="card-body">
            <div class="row mb-3">
                <div class="col-md-6">
                    <p><strong>Company:</strong> {{ $seller->company_name }}</p>
                    <p><strong>Plot:</strong> {{ $seller->plot }}</p>
                    <p><strong>Road:</strong> {{ $seller->road }}</p>
                </div>
                <div class="col-md-6">
                    <p><strong>Avenue:</strong> {{ $seller->avenue }}</p>
                    <p><strong>Telephone:</strong> {{ $seller->telephone }}</p>
                    <p><strong>VAT:</strong> {{ $seller->vat }}</p>
                </div>
            </div>

            <h5 class="mb-3">Company Images</h5>
            <div class="row">
                @foreach(['image1','image2','image3','image4'] as $img)
                    @if($seller->$img)
                        <div class="col-md-3 col-6 mb-3">
                            <div class="card h-100 shadow-sm">
                                <img src="{{ asset($seller["$img"]) }}" 
                                     class="card-img-top rounded" 
                                     alt="Company Image"
                                     style="height:150px; object-fit:cover;">
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
    </div>
</div>

@include('admin.footer')
