@include('admin.header')

<div class="container my-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="mb-0">Company Details</h2>
        <a href="{{ route('admin.sellers.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add Company
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body p-0">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-dark">
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Company</th>
                        <th scope="col">Telephone</th>
                        <th scope="col">VAT</th>
                        <th scope="col">Image</th>
                        <th scope="col" class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($sellers as $seller)
                        <tr>
                            <td>{{ $seller->id }}</td>
                            <td>
                                <strong>{{ $seller->company_name }}</strong><br>
                                <small class="text-muted">{{ $seller->road }} {{ $seller->avenue }} {{ $seller->plot }}</small>
                            </td>
                            <td>{{ $seller->telephone ?? '-' }}</td>
                            <td>{{ $seller->vat ?? '-' }}</td>
                            <td>
                                @if($seller->image1)
                                    <img src="{{ asset($seller->image1) }}" alt="Image" class="img-thumbnail" style="width:60px; height:60px; object-fit:cover;">
                                @else
                                    <span class="text-muted">No Image</span>
                                @endif
                            </td>
                            <td class="text-center">
                                <a href="{{ route('admin.sellers.show', $seller->id) }}" class="btn btn-sm btn-info me-1">
                                    <i class="bi bi-eye"></i> View
                                </a>
                                <a href="{{ route('admin.sellers.edit', $seller->id) }}" class="btn btn-sm btn-warning me-1">
                                    <i class="bi bi-pencil-square"></i> Edit
                                </a>
                                <form action="{{ route('admin.sellers.destroy', $seller->id) }}" method="POST" class="d-inline">
                                    @csrf @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this seller?');">
                                        <i class="bi bi-trash"></i> Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">No sellers found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@include('admin.footer')
