@include('admin.header')

<div class="container my-4">
    <div class="row justify-content-center">
        <div class="col-lg-12">

            <div class="card shadow-sm">
                <div class="card-header bg-dark text-white">
                    <h4 class="mb-0 text-white">Update Company</h4>
                </div>
                <div class="card-body">
                    
                    {{-- Validation Errors --}}
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('admin.sellers.update', $seller->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf 
                        @method('PUT')

                        <div class="mb-3">
                            <label class="form-label">Company Name <span class="text-danger">*</span></label>
                            <input type="text" name="company_name" value="{{ $seller->company_name }}" class="form-control" required>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Plot</label>
                                <input type="text" name="plot" value="{{ $seller->plot }}" class="form-control">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Road</label>
                                <input type="text" name="road" value="{{ $seller->road }}" class="form-control">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Avenue</label>
                                <input type="text" name="avenue" value="{{ $seller->avenue }}" class="form-control">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Telephone</label>
                                <input type="text" name="telephone" value="{{ $seller->telephone }}" class="form-control">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">VAT</label>
                                <input type="text" name="vat" value="{{ $seller->vat }}" class="form-control">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Update Images</label>
                            <div class="row g-3">
                                @for($i = 1; $i <= 4; $i++)
                                    <div class="col-md-3 text-center">
                                        @if($seller["image$i"])
                                            <img src="{{ asset($seller["image$i"]) }}" class="img-thumbnail mb-2" style="width:100px; height:100px; object-fit:cover;">
                                        @else
                                            <div class="border bg-light d-flex align-items-center justify-content-center mb-2" style="width:100px; height:100px;">
                                                <span class="text-muted small">No Image</span>
                                            </div>
                                        @endif
                                        <input type="file" name="image{{ $i }}" class="form-control form-control-sm">
                                    </div>
                                @endfor
                            </div>
                            <small class="text-muted">Leave blank if you don’t want to replace the image</small>
                        </div>

                        <div class="text-end">
                            <button type="submit" class="btn btn-primary px-4">
                                <i class="bi bi-arrow-repeat"></i> Update Company
                            </button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>

@include('admin.footer')
