@include('admin.header')

<div class="container my-4">
    <div class="row justify-content-center">
        <div class="col-lg-12">

            <div class="card shadow-sm">
                <div class="card-header bg-dark text-white">
                    <h4 class="mb-0 text-white">Add Company Detail</h4>
                </div>
                <div class="card-body">
                    
                    {{-- Validation Errors --}}
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('admin.sellers.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="mb-3">
                            <label class="form-label">Company Name <span class="text-danger">*</span></label>
                            <input type="text" name="company_name" class="form-control" placeholder="Enter company name" required>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Plot</label>
                                <input type="text" name="plot" class="form-control" placeholder="Plot number">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Road</label>
                                <input type="text" name="road" class="form-control" placeholder="Road name">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Avenue</label>
                                <input type="text" name="avenue" class="form-control" placeholder="Avenue name">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Telephone</label>
                                <input type="text" name="telephone" class="form-control" placeholder="Telephone number">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">VAT</label>
                                <input type="text" name="vat" class="form-control" placeholder="VAT number">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Upload Company Images</label>
                            <div class="row g-2">
                                <div class="col-md-3">
                                    <input type="file" name="image1" class="form-control">
                                </div>
                                <div class="col-md-3">
                                    <input type="file" name="image2" class="form-control">
                                </div>
                                <div class="col-md-3">
                                    <input type="file" name="image3" class="form-control">
                                </div>
                                <div class="col-md-3">
                                    <input type="file" name="image4" class="form-control">
                                </div>
                            </div>
                            <small class="text-muted">Max size: 2MB per image</small>
                        </div>

                        <div class="text-end">
                            <button type="submit" class="btn btn-success px-4">
                                <i class="bi bi-save"></i> Save Company
                            </button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>

@include('admin.footer')
