@include('admin.header')


@section('title', 'Role Management')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-user-shield me-2"></i>Role Management</h5>
                    <a href="{{ route('admin.roles.create') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus me-1"></i>Create Role
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    @endif

                    @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-hover table-striped">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Role Name</th>
                                    <th>Description</th>
                                    <th>Permissions</th>
                                    <th>Users</th>
                                    <th>Type</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($roles as $role)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        <strong>{{ $role->name }}</strong>
                                        @if($role->name == 'superadmin')
                                            <i class="fas fa-crown text-warning ms-1" title="Super Admin"></i>
                                        @endif
                                    </td>
                                    <td>{{ $role->description }}</td>
                                    <td>
                                        <span class="badge bg-info">{{ $role->permissions_count }}</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary">{{ $role->admins_count }}</span>
                                    </td>
                                    <td>
                                        @if($role->is_default)
                                            <span class="badge bg-secondary">System</span>
                                        @else
                                            <span class="badge bg-success">Custom</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('admin.roles.permissions', $role) }}" class="btn btn-outline-primary" title="Manage Permissions">
                                                <i class="fas fa-key"></i>
                                            </a>
                                            
                                            @if(!$role->is_default || auth('admin')->user()->isSuperAdmin())
                                            <a href="{{ route('admin.roles.edit', $role) }}" class="btn btn-outline-warning" title="Edit Role">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endif

                                            @if(!$role->is_default && $role->name != 'superadmin' && $role->admins_count == 0)
                                            <form action="{{ route('admin.roles.destroy', $role) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-outline-danger" 
                                                        onclick="return confirm('Are you sure you want to delete this role?')"
                                                        title="Delete Role">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    @if($roles->isEmpty())
                    <div class="text-center py-4">
                        <i class="fas fa-user-shield fa-3x text-muted mb-3"></i>
                        <h5>No Roles Found</h5>
                        <p class="text-muted">Get started by creating your first role.</p>
                        <a href="{{ route('admin.roles.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>Create First Role
                        </a>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
