@include('admin.header')


<div class="container">
    <h4 class="mb-4">Create Quotation ({{ $rfq->style }})</h4>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

           @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="zmdi zmdi-check-circle"></i> {{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <form method="POST" action="{{ route('admin.rfqs.quotation.store', $rfq->id) }}" class="bg-white p-3">
        @csrf
        <div class="form-row">
            <div class="form-group col-md-4">
                <label>Revision No</label>
                <input type="text" name="revision_no" class="form-control" placeholder="e.g. Rev 1" required>
            </div>
            <div class="form-group col-md-4">
                <label>Fabric Cost</label>
                <input type="number" step="0.01" name="fabric_cost" id="fabric_cost" class="form-control"
                    value="{{ $rfq->rate * $rfq->quantity }}" readonly>
            </div>
            <div class="form-group col-md-4">
                <label>Accessories Cost</label>
                <input type="number" step="0.01" name="accessories_cost" id="accessories_cost" class="form-control"
                    value="{{ $accessoriesCost }}" readonly>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-4">
                <label>Other Costs</label>
                <input type="number" step="0.01" name="other_costs" id="other_costs" class="form-control">
            </div>
            <div class="form-group col-md-4">
                <label>Overhead (%)</label>
                <input type="number" step="0.01" name="overhead_percent" id="overhead_percent" class="form-control">
            </div>
            <div class="form-group col-md-4">
                <label>Margin (%)</label>
                <input type="number" step="0.01" name="margin_percent" id="margin_percent" class="form-control">
            </div>
        </div>

        <div class="form-group">
            <label>Final Price</label>
            <input type="number" step="0.01" name="final_price" id="final_price" class="form-control" readonly>
        </div>

        <button type="submit" class="btn btn-success"><i class="fas fa-save"></i> Save Quotation</button>
        <a href="{{ route('admin.rfqs.index') }}" class="btn btn-secondary"><i class="fas fa-times"></i> Cancel</a>
    </form>
</div>

<script>
    function calculateFinalPrice() {
        let fabric = parseFloat($('#fabric_cost').val()) || 0;
        let accessories = parseFloat($('#accessories_cost').val()) || 0;
        let other = parseFloat($('#other_costs').val()) || 0;
        let overhead = parseFloat($('#overhead_percent').val()) || 0;
        let margin = parseFloat($('#margin_percent').val()) || 0;

        let subtotal = fabric + accessories + other;
        let overheadAmt = subtotal * (overhead / 100);
        let marginAmt = subtotal * (margin / 100);
        let finalPrice = subtotal + overheadAmt + marginAmt;

        $('#final_price').val(finalPrice.toFixed(2));
    }

    $('#other_costs, #overhead_percent, #margin_percent').on('input', calculateFinalPrice);
</script>
@include('admin.footer')
