@include('admin.header')
<div class="container">
    <h4 class="mb-4">RFQ List</h4>

       @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="zmdi zmdi-check-circle"></i> {{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

    <a href="{{ route('admin.rfqs.create') }}" class="btn btn-primary mb-3"><i class="fas fa-plus"></i> Create RFQ</a>
    <div class="table-responsive">

    <table class="table table-bordered table-striped">
        <thead class="thead-dark">
            <tr>
                <th>#</th>
                <th>Buyer</th>
                <th>Style</th>
                <th>Quantity</th>
                <th>Fabric</th>
                <th>Item Image</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($rfqs as $rfq)
                <tr>
                    <td>{{ $rfq->id }}</td>
                    <td>{{ $rfq->buyer->company_name }}</td>
                    <td>{{ $rfq->style }}</td>
                    <td>{{ $rfq->quantity }}</td>
                    <td>{{ $rfq->fabric->name ?? '-' }}</td>
                    <td>    @if ($rfq->image)
                        <a href="{{ asset('storage/' . $rfq->image) }}" target="_blank">View Image</a>
                @endif</td>
                    <td>
                        <span class="badge badge-{{ $rfq->status == 'draft' ? 'secondary' : ($rfq->status == 'submitted' ? 'success' : 'success') }}">
                            {{ ucfirst($rfq->status) }}
                        </span>
                    </td>
                    <td>
                        <a href="{{ route('admin.rfqs.edit', $rfq->id) }}" class="btn btn-sm btn-info"> <i class="fas fa-edit"></i>Upate</a>
                        <form action="{{ route('admin.rfqs.destroy', $rfq->id) }}" method="POST" style="display:inline;">
                            @csrf @method('DELETE')
                            <button onclick="return confirm('Are you sure?')" class="btn btn-sm btn-danger"><i class="fas fa-trash"></i> Remove</button>
                        </form>
                                                          <a href="{{ route('admin.rfqs.quotation.create', $rfq->id) }}">
    <i class="fas fa-tasks"></i> Quotation Generator
</a>
<a href="{{ route('admin.rfqs.accessories.create', $rfq->id) }}" class="btn btn-sm btn-warning">
    Add Accessory
</a>

                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="7" class="text-center">No RFQs found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

    <div class="d-flex justify-content-center mt-4">
    {{ $rfqs->links() }}
</div>

</div>


@include('admin.footer')
