@include('admin.header')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<div class="container">
    <h4 class="mb-4">Update RFQ</h4>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('admin.rfqs.update', $rfq->id) }}" enctype="multipart/form-data" class="bg-white p-3">
        @csrf @method('PUT')

        <div class="form-row">
            <div class="form-group col-md-6">
                <select name="buyer_id" class="form-control" required>
                    @foreach ($buyers as $buyer)
                        <option value="{{ $buyer->id }}" {{ $rfq->buyer_id == $buyer->id ? 'selected' : '' }}>
                            {{ $buyer->company_name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="form-group col-md-6">
                <input type="text" name="style" class="form-control" value="{{ $rfq->style }}" placeholder="Style Name or Code" required>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <input type="number" name="quantity" class="form-control" value="{{ $rfq->quantity }}" placeholder="Quantity" required>
            </div>
            <div class="form-group col-md-6">
                <select name="fabric_id" id="fabric_id" class="form-control" required>
                    @foreach ($fabrics as $fabric)
                        <option value="{{ $fabric->id }}" {{ $rfq->fabric_id == $fabric->id ? 'selected' : '' }}>
                            {{ $fabric->name }} ({{ $fabric->gsm }} GSM)
                        </option>
                    @endforeach
                </select>
            </div>
        </div>
 <div class="form-row">
  <div class="form-group col-md-4">
      <input type="text" id="gsm" name="gsm" class="form-control" value="{{ $rfq->gsm }}" placeholder="GSM" readonly>
  </div>
  <div class="form-group col-md-4">
      <input type="text" id="wastage_percent" name="wastage_percent" value="{{ $rfq->wastage_percent }}" class="form-control" placeholder="Wastage (%)" readonly>
  </div>
  <div class="form-group col-md-4">
      <input type="text" id="rate" name="rate" class="form-control" value="{{ $rfq->rate }}" placeholder="Rate" readonly>
  </div>
</div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <input type="date" name="delivery_date" class="form-control" value="{{ $rfq->delivery_date }}">
            </div>
            <div class="form-group col-md-6">
                <input type="file" name="image" class="form-control-file">
                @if ($rfq->image)
                    <img src="{{ asset('storage/' . $rfq->image) }}" width="100" class="mt-2">
                @endif
            </div>
        </div>

        <div class="form-group">
            <select name="status" class="form-control">
                <option value="draft" {{ $rfq->status == 'draft' ? 'selected' : '' }}>Draft</option>
                <option value="submitted" {{ $rfq->status == 'submitted' ? 'selected' : '' }}>Submitted</option>
            </select>
        </div>

        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Update RFQ</button>
        <a href="{{ route('admin.rfqs.index') }}" class="btn btn-secondary"><i class="fas fa-times"></i> Cancel</a>
    </form>
</div>
<script>
    $(document).ready(function () {
        let baseUrl = $('meta[name="base-url"]').attr('content');

        $('#fabric_id').on('change', function () {
            let id = $(this).val();

            if (id) {
                $.ajax({
                    url: baseUrl + '/admin/get-fabric-details/' + id,
                    type: 'GET',
                    dataType: 'json',
                    success: function (data) {
                        console.log('Fabric Data:', data);
                        $('#gsm').val(data.gsm);
                        $('#wastage_percent').val(data.wastage_percent);
                        $('#rate').val(data.rate);
                    },
                    error: function (xhr) {
                        console.error('AJAX Error:', xhr.responseText);
                    }
                });
            } else {
                $('#gsm, #wastage_percent, #rate').val('');
            }
        });
    });
</script>


@include('admin.footer')
