@include('admin.header')




<div class="container">
    <h4 class="mb-4">Add Accessory for RFQ: {{ $rfq->style }}</h4>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('admin.rfqs.accessories.store', $rfq->id) }}">
        @csrf
        <div class="form-row">
            <div class="form-group col-md-6">
                <label>Accessory Name</label>
                <input type="text" name="name" class="form-control" placeholder="e.g. Button, Zipper" required>
            </div>
            <div class="form-group col-md-3">
                <label>Quantity</label>
                <input type="number" step="0.01" name="quantity" class="form-control" placeholder="0.00" required>
            </div>
            <div class="form-group col-md-3">
                <label>Rate</label>
                <input type="number" step="0.01" name="rate" class="form-control" placeholder="0.00" required>
            </div>
        </div>

        <button type="submit" class="btn btn-primary"><i class="fas fa-plus"></i> Add Accessory</button>
        <a href="{{ route('admin.rfqs.quotation.create', $rfq->id) }}" class="btn btn-secondary">Back to Quotation</a>
    </form>
</div>

@include('admin.footer')
