@include('admin.header')

<div class="container my-4">
    <div class="row mb-3">
        <div class="col-md-10">
            <h2 class="fw-bold">RFQs</h2>
        </div>
        <div class="col-md-2 text-end">
            <a href="{{ route('admin.rfq.create') }}" class="btn btn-success">
                <i class="bi bi-plus-circle"></i> Create New RFQ
            </a>
        </div>
    </div>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="table-responsive">
        <table class="table table-bordered  align-middle bg-white">
            <thead class="table-dark text-center">
                <tr>
                    <th>ID</th>
                    <th>Brand</th>
                   <th>Item Description</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($rfqs as $rfq)
                    <tr>
                        <td>{{ $rfq->id }}</td>
                                                <td>{{ $rfq->brand->name ?? 'N/A' }}</td>

                        <td>{{ $rfq->itemDescription->name ?? 'N/A' }}</td>
<td>
    @php
        $statusClass = match(strtolower($rfq->status)) {
            'pending' => 'warning',
            'approved' => 'success',
           
        };
    @endphp
    <span class="badge bg-{{ $statusClass }} text-white">{{ ucfirst($rfq->status) }}</span>
</td>
                        <td>{{ $rfq->created_at->format('D, F j, Y') }}</td>
                        <td class="text-center">
                            <div class="dropdown">
                                <button class="btn btn-primary btn-sm dropdown-toggle" type="button" id="actionDropdown{{ $rfq->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                                    Actions
                                </button>
                                <ul class="dropdown-menu" style="z-index: 999!important;" aria-labelledby="actionDropdown{{ $rfq->id }}">
   <li> 

<li>
<a href="{{ route('admin.quotations.create', ['rfq_id' => $rfq->id]) }}">
  <i class="fas fa-calculator"></i> Quotation Generator
</a>



</li>

                                    <li><a class="dropdown-item" href="{{ route('admin.rfq.show', $rfq->id) }}"><i class="fas fa-eye"></i> View</a></li>
                                    <li><a class="dropdown-item" href="{{ route('admin.rfq.edit', $rfq->id) }}"><i class="fas fa-edit"></i> Update</a></li>
                                    <li>
                                        <form action="{{ route('admin.rfq.destroy', $rfq->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this RFQ?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="dropdown-item text-danger"><i class="fas fa-trash"></i> Remove</button>
                                        </form>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="text-center">No RFQs found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-end">
        {{ $rfqs->links() }} {{-- Pagination --}}
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

@include('admin.footer')
