@include('admin.header') 

<style >label{
    font-weight: 700;
}</style>
<div class="container">
    <h1>Udpate RFQ #{{ $rfq->id }}</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

<form action="{{ route('admin.rfq.update', $rfq->id) }}" method="POST" class="bg-white p-3 mt-4 shadow-md">
        @csrf
        @method('PUT')

     <div class="form-group">
            <label for="buyer_id">Buyers</label>
        <select name="buyer_id" id="buyer_id" class="form-control" required>
    <option value="">Select Buyers</option>
    @foreach($buyer as $buyers)
        <option value="{{ $buyers->id }}" {{ old('buyer_id', $rfq->buyer_id) == $buyers->id ? 'selected' : '' }}>
            {{ $buyers->company_name }}
        </option>
    @endforeach
</select>

        </div>

        {{-- Item Description --}}
        <div class="form-group">
            <label for="item_description_id">Item Description</label>
            <select name="item_description_id" id="item_description_id" class="form-control" required>
                <option value="">Select Item Description</option>
                @foreach($itemDescriptions as $description)
                    <option value="{{ $description->id }}" {{ old('item_description_id', $rfq->item_description_id) == $description->id ? 'selected' : '' }}>{{ $description->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Brand --}}
        <div class="form-group">
            <label for="brand_id">Brand</label>
            <select name="brand_id" id="brand_id" class="form-control">
                <option value="">Select Brand (Optional)</option>
                @foreach($brands as $brand)
                    <option value="{{ $brand->id }}" {{ old('brand_id', $rfq->brand_id) == $brand->id ? 'selected' : '' }}>{{ $brand->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Size Range --}}
        <div class="form-group">
            <label for="size_range_id">Size Range</label>
            <select name="size_range_id" id="size_range_id" class="form-control" required>
                <option value="">Select Size Range</option>
                @foreach($sizeRanges as $sizeRange)
                    <option value="{{ $sizeRange->id }}" {{ old('size_range_id', $rfq->size_range_id) == $sizeRange->id ? 'selected' : '' }}>{{ $sizeRange->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Color --}}
        <div class="form-group">
            <label for="color_id">Color</label>
            <select name="color_id" id="color_id" class="form-control" required>
                <option value="">Select Color</option>
                @foreach($colors as $color)
                    <option value="{{ $color->id }}" {{ old('color_id', $rfq->color_id) == $color->id ? 'selected' : '' }}>{{ $color->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Fabric Composition --}}
        <div class="form-group">
            <label for="fabric_composition_id">Fabric Composition</label>
            <select name="fabric_composition_id" id="fabric_composition_id" class="form-control" required>
                <option value="">Select Fabric Composition</option>
                @foreach($fabricCompositions as $composition)
                    <option value="{{ $composition->id }}" {{ old('fabric_composition_id', $rfq->fabric_composition_id) == $composition->id ? 'selected' : '' }}>{{ $composition->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Fabric Type --}}
        <div class="form-group">
            <label for="fabric_type_id">Fabric Type</label>
            <select name="fabric_type_id" id="fabric_type_id" class="form-control" required>
                <option value="">Select Fabric Type</option>
                @foreach($fabricTypes as $type)
                    <option value="{{ $type->id }}" {{ old('fabric_type_id', $rfq->fabric_type_id) == $type->id ? 'selected' : '' }}>{{ $type->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Yarn Count --}}
        <div class="form-group">
            <label for="yarn_count_id">Yarn Count</label>
            <select name="yarn_count_id" id="yarn_count_id" class="form-control" required>
                <option value="">Select Yarn Count</option>
                @foreach($yarnCounts as $count)
                    <option value="{{ $count->id }}" {{ old('yarn_count_id', $rfq->yarn_count_id) == $count->id ? 'selected' : '' }}>{{ $count->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Fabric Weight --}}
        <div class="form-group">
            <label for="fabric_weight_id">Fabric Weight (GSM)</label>
            <select name="fabric_weight_id" id="fabric_weight_id" class="form-control" required>
                <option value="">Select Fabric Weight</option>
                @foreach($fabricWeights as $weight)
                    <option value="{{ $weight->id }}" {{ old('fabric_weight_id', $rfq->fabric_weight_id) == $weight->id ? 'selected' : '' }}>{{ $weight->name }}</option>
                @endforeach
            </select>
        </div>


        {{-- Port of Landing --}}
        <div class="form-group">
            <label for="port_of_landing_id">Port of Landing</label>
            <select name="port_of_landing_id" id="port_of_landing_id" class="form-control" required>
                <option value="">Select Port of Landing</option>
                @foreach($portOfLandings as $port)
                    <option value="{{ $port->id }}" {{ old('port_of_landing_id', $rfq->port_of_landing_id) == $port->id ? 'selected' : '' }}>{{ $port->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Country of Origin --}}
        <div class="form-group">
            <label for="country_of_origin_id">Country of Origin</label>
            <select name="country_of_origin_id" id="country_of_origin_id" class="form-control" required>
                <option value="">Select Country of Origin</option>
                @foreach($countryOfOrigins as $country)
                    <option value="{{ $country->id }}" {{ old('country_of_origin_id', $rfq->country_of_origin_id) == $country->id ? 'selected' : '' }}>{{ $country->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Port of Discharge --}}
        <div class="form-group">
            <label for="port_of_discharge_id">Port of Discharge</label>
            <select name="port_of_discharge_id" id="port_of_discharge_id" class="form-control" required>
                <option value="">Select Port of Discharge</option>
                @foreach($portOfDischarges as $port)
                    <option value="{{ $port->id }}" {{ old('port_of_discharge_id', $rfq->port_of_discharge_id) == $port->id ? 'selected' : '' }}>{{ $port->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Final Destination --}}
        <div class="form-group">
            <label for="final_destination_id">Final Destination</label>
            <select name="final_destination_id" id="final_destination_id" class="form-control" required>
                <option value="">Select Final Destination</option>
                @foreach($finalDestinations as $destination)
                    <option value="{{ $destination->id }}" {{ old('final_destination_id', $rfq->final_destination_id) == $destination->id ? 'selected' : '' }}>{{ $destination->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Delivery Term --}}
        <div class="form-group">
            <label for="delivery_term_id">Delivery Term</label>
            <select name="delivery_term_id" id="delivery_term_id" class="form-control" required>
                <option value="">Select Delivery Term</option>
                @foreach($deliveryTerms as $term)
                    <option value="{{ $term->id }}" {{ old('delivery_term_id', $rfq->delivery_term_id) == $term->id ? 'selected' : '' }}>{{ $term->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Shipment Mode --}}
        <div class="form-group">
            <label for="shipment_mode_id">Shipment Mode</label>
            <select name="shipment_mode_id" id="shipment_mode_id" class="form-control" required>
                <option value="">Select Shipment Mode</option>
                @foreach($shipmentModes as $mode)
                    <option value="{{ $mode->id }}" {{ old('shipment_mode_id', $rfq->shipment_mode_id) == $mode->id ? 'selected' : '' }}>{{ $mode->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Payment Term --}}
        <div class="form-group">
            <label for="payment_term_id">Payment Term</label>
            <select name="payment_term_id" id="payment_term_id" class="form-control" required>
                <option value="">Select Payment Term</option>
                @foreach($paymentTerms as $term)
                    <option value="{{ $term->id }}" {{ old('payment_term_id', $rfq->payment_term_id) == $term->id ? 'selected' : '' }}>{{ $term->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Payment Mode --}}
        <div class="form-group">
            <label for="payment_mode_id">Payment Mode</label>
            <select name="payment_mode_id" id="payment_mode_id" class="form-control" required>
                <option value="">Select Payment Mode</option>
                @foreach($paymentModes as $mode)
                    <option value="{{ $mode->id }}" {{ old('payment_mode_id', $rfq->payment_mode_id) == $mode->id ? 'selected' : '' }}>{{ $mode->name }}</option>
                @endforeach
            </select>
        </div>

        {{-- Remarks --}}
        <div class="form-group">
            <label for="remarks">Remarks</label>
            <textarea name="remarks" id="remarks" class="form-control">{{ old('remarks', $rfq->remarks) }}</textarea>
        </div>

        {{-- Status --}}
  <div class="form-group">
    <label for="status">Status</label>
    <select name="status" id="status" class="form-control" required>
        <option value="pending" {{ (old('status', $rfq->status ?? '') == 'pending') ? 'selected' : '' }}>Pending</option>
        <option value="approved" {{ (old('status', $rfq->status ?? '') == 'approved') ? 'selected' : '' }}>Approved</option>
   
    </select>
</div>


        <button type="submit" class="btn btn-primary">Update RFQ</button>
        <a href="{{ route('admin.rfq.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@include('admin.footer')

