@include('admin.header')

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card shadow-lg border-0">
                <div class="card-header bg-gradient-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="mb-0">
                            <i class="fas fa-calculator me-2"></i>
                            Quotation Details - {{ $quotation->quotation_number }}
                        </h3>
                        <div class="btn-group">
                        <!--     <a href="{{ route('admin.quotations.edit', $quotation) }}" class="btn btn-light btn-sm">
                                <i class="fas fa-edit me-1"></i>Edit
                            </a>
                            <button class="btn btn-warning btn-sm" onclick="duplicateQuotation({{ $quotation->id }})">
                                <i class="fas fa-copy me-1"></i>Duplicate
                            </button> -->
                            @if($quotation->can_convert_to_order)
                                <a href="{{ route('admin.order-confirmations.create') }}?quotation_id={{ $quotation->id }}" class="btn btn-success btn-sm">
                                    <i class="fas fa-arrow-right me-1"></i>Convert to Order
                                </a>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="card-body p-0">
                    <!-- Status Badge and Actions -->
                    <div class="p-3 border-bottom">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <span class="badge bg-{{ $quotation->status_badge_color }} badge-lg fs-6 me-3">
                                    {{ $quotation->status_label }}
                                </span>
                                @if($quotation->has_order)
                                    <a href="{{ route('admin.order-confirmations.show', $quotation->orderConfirmation) }}" 
                                       class="btn btn-outline-success btn-sm">
                                        <i class="fas fa-clipboard-check me-1"></i>View Order Confirmation
                                    </a>
                                @endif
                                <br>
                                <small class="text-muted">
                                    Created: {{ $quotation->created_at->format('M d, Y H:i') }}
                                    @if($quotation->status_updated_at)
                                        | Status updated: {{ $quotation->status_updated_at->format('M d, Y H:i') }}
                                        @if($quotation->statusUpdatedBy)
                                            by {{ $quotation->statusUpdatedBy->name }}
                                        @endif
                                    @endif
                                </small>
                            </div>
                        <div class="dropdown">
    <button class="btn btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
        <i class="fas fa-sync-alt me-1"></i> Update Status
    </button>
    <ul class="dropdown-menu">
        @foreach(['pending' => ['clock', 'primary'], 'won' => ['trophy', 'success'], 'lost' => ['times-circle', 'danger'], 'draft' => ['file-alt', 'secondary'], 'submitted' => ['paper-plane', 'warning']] as $status => [$icon, $color])
            @if($quotation->status !== $status)
                <li>
                    <form action="{{ route('admin.quotations.update-status', $quotation->id) }}" method="POST" style="display:inline;">
                        @csrf
                        <input type="hidden" name="status" value="{{ $status }}">
                        <button type="submit" class="dropdown-item">
                            <i class="fas fa-{{ $icon }} text-{{ $color }} me-2"></i>
                            Mark as {{ ucfirst($status) }}
                        </button>
                    </form>
                </li>
            @endif
        @endforeach
    </ul>
</div>

                        </div>
                        
                        @if($quotation->status_notes)
                            <div class="mt-2 p-2 bg-light rounded">
                                <small class="text-muted"><strong>Status Notes:</strong> {{ $quotation->status_notes }}</small>
                            </div>
                        @endif
                    </div>

                    <!-- Order Conversion Alert -->
                    @if($quotation->status === 'won' && !$quotation->has_order)
                        <div class="p-3 bg-success bg-opacity-10 border-bottom">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-trophy text-success fa-2x me-3"></i>
                                <div class="flex-grow-1">
                                    <h6 class="text-success mb-1">Congratulations! This quotation has been won!</h6>
                                    <p class="mb-0 text-muted">You can now convert this quotation to an order confirmation to proceed with production.</p>
                                </div>
                                <a href="{{ route('admin.order-confirmations.create') }}?quotation_id={{ $quotation->id }}" 
                                   class="btn btn-success">
                                    <i class="fas fa-arrow-right me-1"></i>Convert to Order
                                </a>
                            </div>
                        </div>
                    @elseif($quotation->has_order)
                        <div class="p-3 bg-info bg-opacity-10 border-bottom">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-clipboard-check text-info fa-2x me-3"></i>
                                <div class="flex-grow-1">
                                    <h6 class="text-info mb-1">Order Confirmation Created</h6>
                                    <p class="mb-0 text-muted">
                                        This quotation has been converted to order confirmation 
                                        <strong>{{ $quotation->orderConfirmation->order_number }}</strong>
                                    </p>
                                </div>
                                <a href="{{ route('admin.order-confirmations.show', $quotation->orderConfirmation) }}" 
                                   class="btn btn-info">
                                    <i class="fas fa-eye me-1"></i>View Order
                                </a>
                            </div>
                        </div>
                    @endif

                    <!-- Inquiry Details Section -->
                    <div class="p-4 bg-light border-bottom">
                        <h5 class="text-primary mb-3">
                            <i class="fas fa-info-circle me-2"></i>
                            Inquiry Details
                        </h5>
                        <div class="row g-3">
                            <div class="col-md-3">
                                <div class="info-item">
                                    <label class="text-muted small">Customer</label>
                                    <div class="fw-bold">{{ $quotation->inquiry->buyer->company_name ?? 'N/A' }}</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-item">
                                    <label class="text-muted small">Item Description</label>
                                    <div class="fw-bold">{{ $quotation->inquiry->itemDescription->name ?? 'N/A' }}</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-item">
                                    <label class="text-muted small">Brand</label>
                                    <div class="fw-bold">{{ $quotation->inquiry->brand->name ?? 'N/A' }}</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-item">
                                    <label class="text-muted small">Order Quantity</label>
                                    <div class="fw-bold">{{ number_format($quotation->inquiry->order_quantity) }}</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-item">
                                    <label class="text-muted small">Size Range</label>
                                    <div class="fw-bold">{{ $quotation->inquiry->sizeRange->name ?? 'N/A' }}</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-item">
                                    <label class="text-muted small">Color</label>
                                    <div class="fw-bold">{{ $quotation->inquiry->color->name ?? 'N/A' }}</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-item">
                                    <label class="text-muted small">Target Price</label>
                                    <div class="fw-bold">${{ number_format($quotation->inquiry->target_price, 2) }}</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-item">
                                    <label class="text-muted small">Shipment Date</label>
                                    <div class="fw-bold">{{ $quotation->inquiry->shipment_date ? $quotation->inquiry->shipment_date->format('M d, Y') : 'N/A' }}</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Calculator Display Section -->
                    <div class="p-4">
                        <h5 class="text-primary mb-4">
                            <i class="fas fa-calculator me-2"></i>
                            Cost Calculation Summary
                        </h5>

                        <div class="row g-4">
                            <!-- Fabric Consumption Card -->
                            <div class="col-lg-6">
                                <div class="calculation-card h-100">
                                    <div class="card-header bg-info text-white">
                                        <h6 class="mb-0">
                                            <i class="fas fa-cut me-2"></i>
                                            Fabric Consumption
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="display-value">
                                            {{ number_format($quotation->calculated_total_fabric_consumption, 4) }}
                                            <span class="unit">kg</span>
                                        </div>
                                        <div class="calculation-breakdown">
                                            @if($quotation->costing_details && isset($quotation->costing_details['fabric_consumption']))
                                                @foreach($quotation->costing_details['fabric_consumption'] as $item)
                                                    <div class="breakdown-item">
                                                        <span>{{ $item['name'] ?? 'Item' }}</span>
                                                        <span>{{ number_format($item['consumption'] ?? 0, 4) }} kg</span>
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Fabric Cost Card -->
                            <div class="col-lg-6">
                                <div class="calculation-card h-100">
                                    <div class="card-header bg-success text-white">
                                        <h6 class="mb-0">
                                            <i class="fas fa-dollar-sign me-2"></i>
                                            Fabric Cost
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="display-value">
                                            ${{ number_format($quotation->calculated_total_fabric_cost, 2) }}
                                        </div>
                                        <div class="calculation-breakdown">
                                            @if($quotation->costing_details && isset($quotation->costing_details['fabric_costs']))
                                                @foreach($quotation->costing_details['fabric_costs'] as $item)
                                                    <div class="breakdown-item">
                                                        <span>{{ $item['name'] ?? 'Cost Item' }}</span>
                                                        <span>${{ number_format($item['cost'] ?? 0, 2) }}</span>
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Accessories Cost Card -->
                            <div class="col-lg-6">
                                <div class="calculation-card h-100">
                                    <div class="card-header bg-warning text-white">
                                        <h6 class="mb-0">
                                            <i class="fas fa-puzzle-piece me-2"></i>
                                            Accessories Cost
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="display-value">
                                            ${{ number_format($quotation->calculated_accessories_cost, 2) }}
                                        </div>
                                        <div class="calculation-breakdown">
                                            @if($quotation->costing_details && isset($quotation->costing_details['accessories']))
                                                @foreach($quotation->costing_details['accessories'] as $item)
                                                    <div class="breakdown-item">
                                                        <span>{{ $item['name'] ?? 'Accessory' }}</span>
                                                        <span>${{ number_format($item['total_cost'] ?? 0, 2) }}</span>
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Additional Costs Card -->
                            <div class="col-lg-6">
                                <div class="calculation-card h-100">
                                    <div class="card-header bg-secondary text-white">
                                        <h6 class="mb-0">
                                            <i class="fas fa-plus-circle me-2"></i>
                                            Additional Costs
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="display-value">
                                            ${{ number_format($quotation->calculated_additional_costs_total, 2) }}
                                        </div>
                                        <div class="calculation-breakdown">
                                            @if($quotation->costing_details && isset($quotation->costing_details['other_costs']))
                                                @foreach($quotation->costing_details['other_costs'] as $category => $items)
                                                    <div class="breakdown-category">
                                                        <strong>{{ ucfirst($category) }}</strong>
                                                        @foreach($items as $item)
                                                            <div class="breakdown-item">
                                                                <span>{{ $item['name'] ?? 'Item' }}</span>
                                                                <span>${{ number_format($item['amount'] ?? 0, 2) }}</span>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Total Cost Summary -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="total-summary-card">
                                    <div class="card-header bg-dark text-white">
                                        <h5 class="mb-0">
                                            <i class="fas fa-calculator me-2"></i>
                                            Final Calculation & Profitability
                                        </h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row g-3">
                                            <div class="col-md-3">
                                                <div class="total-item text-center p-3 border rounded">
                                                    <label class="text-muted">Total Cost</label>
                                                    <div class="total-value">${{ number_format($quotation->calculated_total_cost, 2) }}</div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="total-item text-center p-3 border rounded">
                                                    <label class="text-muted">Quoted Price</label>
                                                    <div class="total-value text-success">${{ number_format($quotation->quoted_price, 2) }}</div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="total-item text-center p-3 border rounded">
                                                    <label class="text-muted">Profit Amount</label>
                                                    <div class="total-value {{ $quotation->profit_amount >= 0 ? 'text-success' : 'text-danger' }}">
                                                        ${{ number_format($quotation->profit_amount, 2) }}
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="total-item text-center p-3 border rounded">
                                                    <label class="text-muted">Profit Margin</label>
                                                    <div class="total-value {{ $quotation->profit_margin >= 0 ? 'text-success' : 'text-danger' }}">
                                                        {{ number_format($quotation->profit_margin, 1) }}%
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Comparison with Target Price -->
                                        @if($quotation->inquiry->target_price)
                                            <div class="row mt-3">
                                                <div class="col-12">
                                                    <div class="alert alert-info">
                                                        <h6><i class="fas fa-bullseye me-2"></i>Target Price Comparison</h6>
                                                        <div class="row">
                                                            <div class="col-md-4">
                                                                <strong>Customer Target:</strong> ${{ number_format($quotation->inquiry->target_price, 2) }}
                                                            </div>
                                                            <div class="col-md-4">
                                                                <strong>Our Quote:</strong> ${{ number_format($quotation->quoted_price, 2) }}
                                                            </div>
                                                            <div class="col-md-4">
                                                                @php
                                                                    $targetDifference = $quotation->quoted_price - $quotation->inquiry->target_price;
                                                                    $targetPercentage = $quotation->inquiry->target_price > 0 ? ($targetDifference / $quotation->inquiry->target_price) * 100 : 0;
                                                                @endphp
                                                                <strong>Difference:</strong> 
                                                                <span class="{{ $targetDifference <= 0 ? 'text-success' : 'text-warning' }}">
                                                                    @if($targetDifference > 0)
                                                                        +${{ number_format($targetDifference, 2) }} (+{{ number_format($targetPercentage, 1) }}%)
                                                                    @else
                                                                        ${{ number_format($targetDifference, 2) }} ({{ number_format($targetPercentage, 1) }}%)
                                                                    @endif
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Status Update Modal -->
<!-- <div class="modal fade" id="statusModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Update Quotation Status</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="statusForm">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="new_status" class="form-label">New Status</label>
                        <select name="status" id="new_status" class="form-select" required>
                            <option value="draft">Draft</option>
                            <option value="submitted">Submitted</option>
                            <option value="approved">Approved</option>
                            <option value="rejected">Rejected</option>
                            <option value="pending">Pending</option>
                            <option value="won">Won</option>
                            <option value="lost">Lost</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="status_notes" class="form-label">Notes (Optional)</label>
                        <textarea name="notes" id="status_notes" class="form-control" rows="3" 
                                  placeholder="Add any notes about this status change..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Status</button>
                </div>
            </form>
        </div>
    </div>
</div> -->

<style>
.calculation-card {
    border: 1px solid #dee2e6;
    border-radius: 0.375rem;
    overflow: hidden;
}

.display-value {
    font-size: 2rem;
    font-weight: bold;
    color: #495057;
}

.unit {
    font-size: 1rem;
    color: #6c757d;
}

.breakdown-item {
    display: flex;
    justify-content: space-between;
    padding: 0.25rem 0;
    border-bottom: 1px solid #f8f9fa;
}

.breakdown-category {
    margin-bottom: 1rem;
}

.total-summary-card {
    border: 2px solid #dee2e6;
    border-radius: 0.5rem;
    overflow: hidden;
}

.total-item label {
    font-size: 0.875rem;
    margin-bottom: 0.5rem;
    display: block;
}

.total-value {
    font-size: 1.5rem;
    font-weight: bold;
}

.badge-lg {
    padding: 0.5rem 1rem;
    font-size: 0.875rem;
}
</style>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

@include('admin.footer')

