@include('admin.header')
<style>.modal {
    z-index: 9999 !important;
}
.modal-backdrop {
    z-index: 9998 !important;
}
.modal-backdrop.show{
    opacity: 0!important;
    z-index: -9999999;
    display: none!important;
}
</style>

<div class='container'>
    <div class='row mb-3'>
        <div class='col-md-6'>
            <h1><i class='fas fa-calculator me-2'></i>Quotations</h1>
        </div>
        <div class='col-md-6 text-right'>
            <a href='{{ route('admin.inquiries.index') }}'' class='btn btn-primary'>
                <i class='fas fa-plus me-1'></i>Create New Quotation (Select Inquiry)
            </a> 
        </div>
    </div>

    @if (session('success'))
        <div class='alert alert-success alert-dismissible fade show'>
            <i class='fas fa-check-circle me-2'></i>{{ session('success') }}
            <button type='button' class='btn-close' data-bs-dismiss='alert'></button>
        </div>
    @endif
    @if (session('error'))
        <div class='alert alert-danger alert-dismissible fade show'>
            <i class='fas fa-exclamation-circle me-2'></i>{{ session('error') }}
            <button type='button' class='btn-close' data-bs-dismiss='alert'></button>
        </div>
    @endif

    <!-- Status Dashboard Cards -->
    <div class='row mb-4'>
        <div class='col-md-2'>
            <div class='card bg-primary text-white'>
                <div class='card-body text-center'>
                    <h4>{{ $statusCounts['pending'] }}</h4>
                    <small>Pending</small>
                    <div class='mt-2'>
                        <a href='{{ route('admin.quotations.index') }}?status=pending' class='btn btn-light btn-sm'>View</a>
                    </div>
                </div>
            </div>
        </div>
        <div class='col-md-2'>
            <div class='card bg-success text-white'>
                <div class='card-body text-center'>
                    <h4>{{ $statusCounts['won'] }}</h4>
                    <small>Won</small>
                    <div class='mt-2'>
                        <a href='{{ route('admin.quotations.index') }}?status=won' class='btn btn-light btn-sm'>View</a>
                    </div>
                </div>
            </div>
        </div>
        <div class='col-md-2'>
            <div class='card bg-dark text-white'>
                <div class='card-body text-center'>
                    <h4>{{ $statusCounts['lost'] }}</h4>
                    <small>Lost</small>
                    <div class='mt-2'>
                        <a href='{{ route('admin.quotations.index') }}?status=lost' class='btn btn-light btn-sm'>View</a>
                    </div>
                </div>
            </div>
        </div>
        <div class='col-md-2'>
            <div class='card bg-secondary text-white'>
                <div class='card-body text-center'>
                    <h4>{{ $statusCounts['draft'] }}</h4>
                    <small>Draft</small>
                    <div class='mt-2'>
                        <a href='{{ route('admin.quotations.index') }}?status=draft' class='btn btn-light btn-sm'>View</a>
                    </div>
                </div>
            </div>
        </div>
        <div class='col-md-2'>
            <div class='card bg-warning text-white'>
                <div class='card-body text-center'>
                    <h4>{{ $statusCounts['submitted'] }}</h4>
                    <small>Submitted</small>
                    <div class='mt-2'>
                        <a href='{{ route('admin.quotations.index') }}?status=submitted' class='btn btn-light btn-sm'>View</a>
                    </div>
                </div>
            </div>
        </div>
        <div class='col-md-2'>
            <div class='card bg-info text-white'>
                <div class='card-body text-center'>
                    <h4>{{ $quotations->total() }}</h4>
                    <small>Total</small>
                    <div class='mt-2'>
                        <a href='{{ route('admin.quotations.index') }}'' class='btn btn-light btn-sm'>View All</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class='card mb-4'>
        <div class='card-body'>
            <form method='GET' action='{{ route('admin.quotations.index') }}'' class='row g-3'>
                <div class='col-md-3'>
                    <label for='status' class='form-label'>Status</label>
                    <select name='status' id='status' class='form-select'>
                        <option value=''>All Statuses</option>
                        <option value='pending' {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value='won' {{ request('status') == 'won' ? 'selected' : '' }}>Won</option>
                        <option value='lost' {{ request('status') == 'lost' ? 'selected' : '' }}>Lost</option>
                        <option value='draft' {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                        <option value='submitted' {{ request('status') == 'submitted' ? 'selected' : '' }}>Submitted</option>
                        <option value='approved' {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                        <option value='rejected' {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                    </select>
                </div>
                <div class='col-md-4'>
                    <label for='search' class='form-label'>Search</label>
                    <input type='text' name='search' id='search' class='form-control' 
                           placeholder='Quotation number, customer name...' value='{{ request('search') }}'>
                </div>
                <div class='col-md-3 d-flex align-items-end'>
                    <button type='submit' class='btn btn-primary me-2'>
                        <i class='fas fa-search me-1'></i>Filter
                    </button>
                    <a href='{{ route('admin.quotations.index') }}'' class='btn btn-outline-secondary'>
                        <i class='fas fa-times me-1'></i>Clear
                    </a>
                </div>
                <div class='col-md-2 d-flex align-items-end'>
                    @if(request('status') == 'pending')
                        <button type='button' class='btn btn-outline-success btn-sm' data-bs-toggle='modal' data-bs-target='#bulkStatusModal'>
                            <i class='fas fa-tasks me-1'></i>Bulk Update
                        </button>
                    @endif
                </div>
            </form>
        </div>
    </div>

    <div class='card'>
        <div class='card-body'>
            @if(request('status'))
                <div class='alert alert-info'>
                    <i class='fas fa-filter me-2'></i>
                    Showing quotations with status: <strong>{{ ucfirst(request('status')) }}</strong>
                    <a href='{{ route('admin.quotations.index') }}'' class='btn btn-sm btn-outline-primary ms-2'>Show All</a>
                </div>
            @endif

            <div class='table-responsive'>
                <table class='table table-bordered table-striped'>
                    <thead class='table-dark'>
                        <tr>
                            @if(request('status') == 'pending')
                                <th width='30'>
                                    <input type='checkbox' id='selectAll' class='form-check-input'>
                                </th>
                            @endif
                            <th>ID</th>
                            <th>Quotation No.</th>
                            <th>Inquiry ID</th>
                            <th>Customer</th>
                            <th>Item Description</th>
                            <th>Total Cost</th>
                            <th>Quoted Price</th>
                            <th>Profit</th>
                            <th>Status</th>
                            <th>Created At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($quotations as $quotation)
                            <tr>
                                @if(request('status') == 'pending')
                                    <td>
                                        <input type='checkbox' name='quotation_ids[]' value='{{ $quotation->id }}'' class='form-check-input quotation-checkbox'>
                                    </td>
                                @endif
                                <td>{{ $quotation->id }}</td>
                                <td><strong>{{ $quotation->quotation_number ?? 'N/A' }}</strong></td>
                                <td>
                                    <a href='{{ route('admin.inquiries.show', $quotation->inquiry_id) }}'' class='text-decoration-none'>
                                        {{ $quotation->inquiry_id }}
                                    </a>
                                </td>
                                <td>{{ $quotation->inquiry->buyer->company_name ?? 'N/A' }}</td>
                                <td>{{ $quotation->inquiry->itemDescription->name ?? 'N/A' }}</td>
                                <td>${{ number_format($quotation->calculated_total_cost, 2) }}</td>
                                <td><strong>${{ number_format($quotation->quoted_price, 2) }}</strong></td>
                                <td>
                                    <span class='badge bg-{{ $quotation->profit_amount >= 0 ? 'success' : 'danger' }}'>
                                        ${{ number_format($quotation->profit_amount, 2) }}
                                        ({{ number_format($quotation->profit_margin, 1) }}%)
                                    </span>
                                </td>
                                <td>
                                    <span class='badge bg-{{ $quotation->status_badge_color }}'>
                                        {{ $quotation->status_label }}
                                    </span>
                                    @if($quotation->has_order)
                                        <br><small class='text-success'><i class='fas fa-check-circle'></i> Has Order</small>
                                    @endif
                                </td>
                                <td>{{ $quotation->created_at->format('Y-m-d H:i') }}</td>
                                <td>
                                    <div class='btn-group' role='group'>
                                        <a href='{{ route('admin.quotations.show', $quotation->id) }}'' class='btn btn-info btn-sm' title='View'>
                                            <i class='fas fa-eye'></i>
                                        </a>
                                        <a href='{{ route('admin.quotations.edit', $quotation->id) }}'' class='btn btn-warning btn-sm' title='Edit'>
                                            <i class='fas fa-edit'></i>
                                        </a>
                                        
                                        <!-- Status Management Dropdown -->
                                        <div class='btn-group' role='group'>
                                            <button type='button' class='btn btn-primary btn-sm dropdown-toggle' data-bs-toggle='dropdown' title='Update Status'>
                                                <i class='fas fa-sync-alt'></i>
                                            </button>
                                            <ul class='dropdown-menu'>
                                                @if($quotation->status !== 'pending')
                                                    <li>
                                                        <form action='{{ route('admin.quotations.update-status', $quotation) }}'' method='POST'>
                                                            @csrf
                                                            <input type='hidden' name='status' value='pending'>
                                                            <button type='submit' class='dropdown-item'>
                                                                <i class='fas fa-clock text-primary me-2'></i>Mark as Pending
                                                            </button>
                                                        </form>
                                                    </li>
                                                @endif
                                                @if($quotation->status !== 'won')
                                                    <li>
                                                        <form action='{{ route('admin.quotations.update-status', $quotation) }}'' method='POST'>
                                                            @csrf
                                                            <input type='hidden' name='status' value='won'>
                                                            <button type='submit' class='dropdown-item'>
                                                                <i class='fas fa-trophy text-success me-2'></i>Mark as Won
                                                            </button>
                                                        </form>
                                                    </li>
                                                @endif
                                                @if($quotation->status !== 'lost')
                                                    <li>
                                                        <form action='{{ route('admin.quotations.update-status', $quotation) }}'' method='POST'>
                                                            @csrf
                                                            <input type='hidden' name='status' value='lost'>
                                                            <button type='submit' class='dropdown-item'>
                                                                <i class='fas fa-times-circle text-danger me-2'></i>Mark as Lost
                                                            </button>
                                                        </form>
                                                    </li>
                                                @endif
                                            </ul>
                                        </div>

                                        <!-- Convert to Order Button -->
                                        @if($quotation->can_convert_to_order)
                                            <a href='{{ route('admin.order-confirmations.create') }}?quotation_id={{ $quotation->id }}'' 
                                               class='btn btn-success btn-sm' title='Convert to Order'>
                                                <i class='fas fa-arrow-right'></i>
                                            </a>
                                        @elseif($quotation->has_order)
                                            <a href='{{ route('admin.order-confirmations.show', $quotation->orderConfirmation) }}'' 
                                               class='btn btn-outline-success btn-sm' title='View Order'>
                                                <i class='fas fa-clipboard-check'></i>
                                            </a>
                                        @endif

                                        <!-- Delete Button -->
                                        @if(!$quotation->has_order)
                                            <form action='{{ route('admin.quotations.destroy', $quotation->id) }}'' method='POST' style='display:inline-block;'>
                                                @csrf
                                                @method('DELETE')
                                                <button type='submit' class='btn btn-danger btn-sm' 
                                                        onclick='return confirm('Are you sure you want to delete this quotation?')' title='Delete'>
                                                    <i class='fas fa-trash'></i>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan='{{ request('status') == 'pending' ? '12' : '11' }}'' class='text-center py-4'>
                                    <i class='fas fa-inbox fa-3x text-muted mb-3'></i>
                                    <p class='text-muted'>No quotations found.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            @if ($quotations->hasPages())
                <div class='d-flex justify-content-center mt-3'>
                    {{ $quotations->links() }}
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Bulk Status Update Modal -->
<div class='modal fade' id='bulkStatusModal' tabindex='-1'>
    <div class='modal-dialog'>
        <div class='modal-content'>
            <div class='modal-header'>
                <h5 class='modal-title'>Bulk Update Status</h5>
                <button type='button' class='btn-close' data-bs-dismiss='modal'></button>
            </div>
            <form id='bulkStatusForm' action='{{ route('admin.quotations.bulk-update-status') }}'' method='POST'>
                @csrf
                <div class='modal-body'>
                    <div class='mb-3'>
                        <label class='form-label'>Selected Quotations: <span id='selectedCount'>0</span></label>
                    </div>
                    <div class='mb-3'>
                        <label for='bulk_status' class='form-label'>New Status</label>
                        <select name='status' id='bulk_status' class='form-select' required>
                            <option value='won'>Won</option>
                            <option value='lost'>Lost</option>
                        </select>
                    </div>
                    <div class='mb-3'>
                        <label for='bulk_notes' class='form-label'>Notes (Optional)</label>
                        <textarea name='notes' id='bulk_notes' class='form-control' rows='3' 
                                  placeholder='Add any notes about this status change...'></textarea>
                    </div>
                </div>
                <div class='modal-footer'>
                    <button type='button' class='btn btn-secondary' data-bs-dismiss='modal'>Cancel</button>
                    <button type='submit' class='btn btn-primary'>Update Selected</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Bulk operations
function showBulkStatusModal() {
    const selected = document.querySelectorAll('.quotation-checkbox:checked');
    if (selected.length === 0) {
        alert('Please select at least one quotation');
        return;
    }
    
    document.getElementById('selectedCount').textContent = selected.length;
    
    // Add selected IDs to form
    const form = document.getElementById('bulkStatusForm');
    // Remove existing hidden inputs
    form.querySelectorAll('input[name="quotation_ids[]"]').forEach(input => input.remove());
    
    // Add new hidden inputs
    selected.forEach(checkbox => {
        const input = document.createElement('input');
        input.type = 'hidden';
        input.name = 'quotation_ids[]';
        input.value = checkbox.value;
        form.appendChild(input);
    });
    
    new bootstrap.Modal(document.getElementById('bulkStatusModal')).show();
}

// Select all functionality
document.getElementById('selectAll')?.addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.quotation-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

// Update select all when individual checkboxes change
document.querySelectorAll('.quotation-checkbox').forEach(checkbox => {
    checkbox.addEventListener('change', function() {
        const allCheckboxes = document.querySelectorAll('.quotation-checkbox');
        const checkedCheckboxes = document.querySelectorAll('.quotation-checkbox:checked');
        const selectAllCheckbox = document.getElementById('selectAll');
        
        if (selectAllCheckbox) {
            selectAllCheckbox.checked = allCheckboxes.length === checkedCheckboxes.length;
            selectAllCheckbox.indeterminate = checkedCheckboxes.length > 0 && checkedCheckboxes.length < allCheckboxes.length;
        }
    });
});
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

@include('admin.footer')

