@include('admin.header')

@section('title', 'Payment Ledger')

@section('actions')
    <a href="{{ route('admin.advance-payments.index') }}" class="btn btn-secondary">
        <i class="fas fa-money-bill-wave me-1"></i> Advance Payments
    </a>
    <form action="{{ route('admin.payment-ledger.update-all') }}" method="POST" class="d-inline">
        @csrf
        <button type="submit" class="btn btn-warning">
            <i class="fas fa-sync-alt me-1"></i> Update All Ledgers
        </button>
    </form>
@endsection

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Payment Ledger - All Buyers</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead class="table-dark">
                            <tr>
                                <th>Buyer</th>
                                <th>Total In ($)</th>
                                <th>Total Out ($)</th>
                                <th>Current Balance ($)</th>
                                <th>Last Updated</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($ledgers as $ledger)
                            <tr>
                                <td>{{ $ledger->buyer->company_name }}</td>
                                <td class="text-success fw-bold">${{ number_format($ledger->total_in, 2) }}</td>
                                <td class="text-danger fw-bold">${{ number_format($ledger->total_out, 2) }}</td>
                                <td class="fw-bold {{ $ledger->current_balance >= 0 ? 'text-success' : 'text-danger' }}">
                                    ${{ number_format($ledger->current_balance, 2) }}
                                </td>
                                <td>{{ $ledger->last_updated->format('M d, Y H:i') }}</td>
                                <td>
                                    <a href="{{ route('admin.payment-ledger.show', $ledger->buyer) }}" class="btn btn-sm btn-primary">
                                        <i class="fas fa-list me-1"></i> Details
                                    </a>
                                    <a href="{{ route('admin.payment-ledger.buyer-report', $ledger->buyer) }}" class="btn btn-sm btn-info" target="_blank">
                                        <i class="fas fa-download me-1"></i> PDF
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <div class="d-flex justify-content-center">
                    {{ $ledgers->links() }}
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Summary Cards -->
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <h6 class="card-title">Total Payments</h6>
                <h3>${{ number_format($ledgers->sum('total_in'), 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h6 class="card-title">Total Allocations</h6>
                <h3>${{ number_format($ledgers->sum('total_out'), 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <h6 class="card-title">Net Balance</h6>
                <h3>${{ number_format($ledgers->sum('current_balance'), 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-dark">
            <div class="card-body">
                <h6 class="card-title">Active Buyers</h6>
                <h3>{{ $ledgers->count() }}</h3>
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
