@include('admin.header')

@section('title', 'Bank Invoice Details')

@section('actions')
    <a href="{{ route('admin.bank-invoices.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Invoices
    </a>
    <a href="{{ route('admin.bank-invoices.edit', $bankInvoice) }}" class="btn btn-warning">
        <i class="fas fa-edit me-1"></i> Edit
    </a>
    <a href="{{ route('admin.bank-invoices.export-pdf', $bankInvoice) }}" class="btn btn-info" target="_blank">
        <i class="fas fa-download me-1"></i> Export PDF
    </a>
    @if($bankInvoice->status === 'draft')
    <form action="{{ route('admin.bank-invoices.mark-sent', $bankInvoice) }}" method="POST" class="d-inline">
        @csrf
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-paper-plane me-1"></i> Mark as Sent
        </button>
    </form>
    @endif
    @if($bankInvoice->status === 'sent')
    <form action="{{ route('admin.bank-invoices.mark-paid', $bankInvoice) }}" method="POST" class="d-inline">
        @csrf
        <button type="submit" class="btn btn-success">
            <i class="fas fa-check me-1"></i> Mark as Paid
        </button>
    </form>
    @endif
@endsection

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Invoice Details</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Invoice Number</th>
                                <td>{{ $bankInvoice->invoice_number }}</td>
                            </tr>
                            <tr>
                                <th>Buyer</th>
                                <td>{{ $bankInvoice->buyer->contact_person }}</td>
                            </tr>
                            <tr>
                                <th>Order Confirmation</th>
                                <td>{{ $bankInvoice->orderConfirmation->order_number }}</td>
                            </tr>
                            <tr>
                                <th>Invoice Amount</th>
                                <td class="fw-bold">${{ number_format($bankInvoice->amount, 2) }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Invoice Date</th>
                                <td>{{ $bankInvoice->invoice_date->format('M d, Y') }}</td>
                            </tr>
                            <tr>
                                <th>Due Date</th>
                                <td class="{{ $bankInvoice->is_overdue ? 'text-danger fw-bold' : '' }}">
                                    {{ $bankInvoice->due_date->format('M d, Y') }}
                                    @if($bankInvoice->is_overdue)
                                    <br><small class="text-danger">(Overdue)</small>
                                    @else
                                    <br><small class="text-muted">({{ $bankInvoice->days_until_due }} days remaining)</small>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Tax Amount</th>
                                <td>${{ number_format($bankInvoice->tax_amount, 2) }}</td>
                            </tr>
                            <tr>
                                <th>Total Amount</th>
                                <td class="fw-bold text-success">${{ number_format($bankInvoice->total_amount, 2) }}</td>
                                
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Status</th>
                                <td>
                                    <span class="badge bg-{{ $bankInvoice->status_badge_color }} text-white">
                                        {{ ucfirst($bankInvoice->status) }}
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <th>Created By</th>
                                <td>{{ $bankInvoice->creator->name }}</td>
                            </tr>
                            <tr>
                                <th>Created At</th>
                                <td>{{ $bankInvoice->created_at->format('M d, Y H:i') }}</td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Description</label>
                            <div class="border p-3 bg-light rounded">
                                {{ $bankInvoice->description }}
                            </div>
                        </div>
                    </div>
                </div>

                @if($bankInvoice->bank_remarks)
                <div class="row">
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Bank Remarks</label>
                            <div class="border p-3 bg-light rounded">
                                {{ $bankInvoice->bank_remarks }}
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Buyer Information</h6>
            </div>
            <div class="card-body">
                <h6>{{ $bankInvoice->buyer->company_name }}</h6>
                <ul class="list-unstyled">
                    <li><strong>Contact:</strong> {{ $bankInvoice->buyer->contact_person }}</li>
                    <li><strong>Email:</strong> {{ $bankInvoice->buyer->email }}</li>
                    <li><strong>Phone:</strong> {{ $bankInvoice->buyer->phone }}</li>
                    <li><strong>Address:</strong> {{ $bankInvoice->buyer->address }}</li>
                    <li><strong>Country:</strong> {{ $bankInvoice->buyer->country }}</li>
                </ul>
                
                @if($bankInvoice->buyer->bank)
                <hr>
                <h6>Bank Details</h6>
                <ul class="list-unstyled">
                    <li><strong>Bank:</strong> {{ $bankInvoice->buyer->bank->bank_name }}</li>
                    <li><strong>Account:</strong> {{ $bankInvoice->buyer->bank->account_no }}</li>
                    <li><strong>SWIFT:</strong> {{ $bankInvoice->buyer->bank->swift }}</li>
                </ul>
                @endif
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Order Information</h6>
            </div>
            <div class="card-body">
                <h6>{{ $bankInvoice->orderConfirmation->order_number }}</h6>
                <ul class="list-unstyled">
                    <li><strong>Quantity:</strong> {{ number_format($bankInvoice->orderConfirmation->confirmed_quantity) }}</li>
                    <li><strong>Price:</strong> ${{ number_format($bankInvoice->orderConfirmation->confirmed_price, 2) }}</li>
                    <li><strong>Total Value:</strong> ${{ number_format($bankInvoice->orderConfirmation->total_value, 2) }}</li>
                    <li><strong>Delivery:</strong> {{ $bankInvoice->orderConfirmation->formatted_delivery_date }}</li>
                    <li><strong>Status:</strong> 
                        <span class="badge bg-{{ $bankInvoice->orderConfirmation->status_badge_color }} text-white">
                            {{ ucfirst($bankInvoice->orderConfirmation->status) }}
                        </span>
                    </li>
                </ul>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Quick Actions</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.bank-invoices.export-pdf', $bankInvoice) }}" class="btn btn-outline-primary mb-4" target="_blank">
                        <i class="fas fa-file-pdf me-1"></i> Download PDF
                    </a>
                    @if($bankInvoice->status === 'draft')
                    <form action="{{ route('admin.bank-invoices.mark-sent', $bankInvoice) }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-outline-success w-100">
                            <i class="fas fa-paper-plane me-1"></i> Mark as Sent
                        </button>
                    </form>
                    @endif
                    @if($bankInvoice->status === 'sent')
                    <form action="{{ route('admin.bank-invoices.mark-paid', $bankInvoice) }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-outline-success w-100">
                            <i class="fas fa-check me-1"></i> Mark as Paid
                        </button>
                    </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
