@include('admin.header')

@section('title', 'Bank Invoices')
    <a href="{{ route('admin.bank-invoices.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-1"></i> Create Invoice
    </a>

<div class="card mt-5">
    <div class="card-header">
        <h5 class="card-title mb-0">Invoice to Bank</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Invoice No</th>
                        <th>Buyer</th>
                        <th>Order</th>
                        <th>Invoice Date</th>
                        <th>Due Date</th>
                        <th>Total Amount</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($invoices as $invoice)
                    <tr class="{{ $invoice->is_overdue ? 'table-warning' : '' }}">
                        <td>{{ $invoice->invoice_number }}</td>
                        <td>{{ $invoice->buyer->company_name }}</td>
                        <td>{{ $invoice->orderConfirmation->order_number }}</td>
                        <td>{{ $invoice->invoice_date->format('M d, Y') }}</td>
                        <td>
                            <span class="{{ $invoice->is_overdue ? 'text-danger fw-bold' : '' }}">
                                {{ $invoice->due_date->format('M d, Y') }}
                            </span>
                        </td>
                        <td>${{ number_format($invoice->total_amount, 2) }}</td>
                        <td>
                            <span class="badge text-white bg-{{ $invoice->status_badge_color }} status-badge">
                                {{ ucfirst($invoice->status) }}
                            </span>
                            @if($invoice->is_overdue)
                            <span class="badge bg-danger status-badge">Overdue</span>
                            @endif
                        </td>
                        <td class="table-actions">
                            <a href="{{ route('admin.bank-invoices.show', $invoice) }}" class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="{{ route('admin.bank-invoices.edit', $invoice) }}" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <a href="{{ route('admin.bank-invoices.export-pdf', $invoice) }}" class="btn btn-sm btn-secondary" target="_blank">
                                <i class="fas fa-download"></i>
                            </a>
                            @if($invoice->status === 'draft')
                            <form action="{{ route('admin.bank-invoices.mark-sent', $invoice) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-sm btn-primary" title="Mark as Sent">
                                    <i class="fas fa-paper-plane"></i>
                                </button>
                            </form>
                            @endif
                            @if($invoice->status === 'sent')
                            <form action="{{ route('admin.bank-invoices.mark-paid', $invoice) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-sm btn-success" title="Mark as Paid">
                                    <i class="fas fa-check"></i>
                                </button>
                            </form>
                            @endif
                            <form action="{{ route('admin.bank-invoices.destroy', $invoice) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <div class="d-flex justify-content-center">
            {{ $invoices->links() }}
        </div>
    </div>
</div>

<!-- Summary Cards -->
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <h6 class="card-title">Total Invoices</h6>
                <h3>{{ $invoices->total() }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h6 class="card-title">Paid</h6>
                <h3>{{ $invoices->where('status', 'paid')->count() }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-dark">
            <div class="card-body">
                <h6 class="card-title">Pending</h6>
                <h3>{{ $invoices->whereIn('status', ['draft', 'sent'])->count() }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-danger text-white">
            <div class="card-body">
                <h6 class="card-title">Overdue</h6>
                <h3>{{ $invoices->where('is_overdue', true)->count() }}</h3>
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
