@include('admin.header')

@section('title', 'Edit Bank Invoice')

@section('actions')
    <a href="{{ route('admin.bank-invoices.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Invoices
    </a>
@endsection

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Edit Bank Invoice</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.bank-invoices.update', $bankInvoice) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="buyer_id" class="form-label">Buyer *</label>
                                <select name="buyer_id" id="buyer_id" class="form-select" required>
                                    <option value="">Select Buyer</option>
                                    @foreach($buyers as $buyer)
                                    <option value="{{ $buyer->id }}" {{ $bankInvoice->buyer_id == $buyer->id ? 'selected' : '' }}>
                                        {{ $buyer->company_name }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('buyer_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="order_confirmation_id" class="form-label">Order Confirmation *</label>
                                <select name="order_confirmation_id" id="order_confirmation_id" class="form-select" required>
                                    <option value="">Select Order</option>
                                    @foreach($orders as $order)
                                    <option value="{{ $order->id }}" {{ $bankInvoice->order_confirmation_id == $order->id ? 'selected' : '' }}>
                                        {{ $order->order_number }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('order_confirmation_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="invoice_date" class="form-label">Invoice Date *</label>
                                <input type="date" name="invoice_date" id="invoice_date" 
                                       class="form-control" value="{{ old('invoice_date', $bankInvoice->invoice_date->format('Y-m-d')) }}" required>
                                @error('invoice_date')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="due_date" class="form-label">Due Date *</label>
                                <input type="date" name="due_date" id="due_date" 
                                       class="form-control" value="{{ old('due_date', $bankInvoice->due_date->format('Y-m-d')) }}" required>
                                @error('due_date')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount" class="form-label">Invoice Amount ($) *</label>
                                <input type="number" step="0.01" min="0.01" name="amount" id="amount" 
                                       class="form-control" value="{{ old('amount', $bankInvoice->amount) }}" required>
                                @error('amount')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tax_amount" class="form-label">Tax Amount ($)</label>
                                <input type="number" step="0.01" min="0" name="tax_amount" id="tax_amount" 
                                       class="form-control" value="{{ old('tax_amount', $bankInvoice->tax_amount) }}">
                                @error('tax_amount')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status" class="form-label">Status *</label>
                                <select name="status" id="status" class="form-select" required>
                                    <option value="draft" {{ $bankInvoice->status == 'draft' ? 'selected' : '' }}>Draft</option>
                                    <option value="sent" {{ $bankInvoice->status == 'sent' ? 'selected' : '' }}>Sent</option>
                                    <option value="paid" {{ $bankInvoice->status == 'paid' ? 'selected' : '' }}>Paid</option>
                                    <option value="cancelled" {{ $bankInvoice->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                </select>
                                @error('status')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description *</label>
                        <textarea name="description" id="description" class="form-control" rows="4" required>{{ old('description', $bankInvoice->description) }}</textarea>
                        @error('description')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="bank_remarks" class="form-label">Bank Remarks</label>
                        <textarea name="bank_remarks" id="bank_remarks" class="form-control" rows="2">{{ old('bank_remarks', $bankInvoice->bank_remarks) }}</textarea>
                        @error('bank_remarks')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="{{ route('admin.bank-invoices.index') }}" class="btn btn-secondary me-2">Cancel</a>&nbsp;
                        <button type="submit" class="btn btn-primary">Update Invoice</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Invoice Summary</h6>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Invoice Number:</strong><br>
                    {{ $bankInvoice->invoice_number }}
                </div>
                <div class="mb-3">
                    <strong>Total Amount:</strong><br>
                    <span class="fw-bold text-success">${{ number_format($bankInvoice->total_amount, 2) }}</span>
                </div>
                <div class="mb-3">
                    <strong>Current Status:</strong><br>
                    <span class="badge bg-{{ $bankInvoice->status_badge_color }} text-white">
                        {{ ucfirst($bankInvoice->status) }}
                    </span>
                </div>
                <div class="mb-3">
                    <strong>Due Status:</strong><br>
                    @if($bankInvoice->is_overdue)
                    <span class="badge bg-danger text-white">Overdue</span>
                    @else
                    <span class="badge bg-success text-white">On Time</span>
                    @endif
                </div>
                <div class="mb-3">
                    <strong>Created By:</strong><br>
                    {{ $bankInvoice->creator->name }}<br>
                    <small class="text-muted">{{ $bankInvoice->created_at->format('M d, Y H:i') }}</small>
                </div>
                <div class="mb-3">
                    <strong>Last Updated:</strong><br>
                    <small class="text-muted">{{ $bankInvoice->updated_at->format('M d, Y H:i') }}</small>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Quick Actions</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.bank-invoices.export-pdf', $bankInvoice) }}" class="btn btn-outline-primary" target="_blank">
                        <i class="fas fa-file-pdf me-1"></i> Download PDF
                    </a>
                    @if($bankInvoice->status === 'draft')
                    <form action="{{ route('admin.bank-invoices.mark-sent', $bankInvoice) }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-outline-success w-100">
                            <i class="fas fa-paper-plane me-1"></i> Mark as Sent
                        </button>
                    </form>
                    @endif
                    @if($bankInvoice->status === 'sent')
                    <form action="{{ route('admin.bank-invoices.mark-paid', $bankInvoice) }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-outline-success w-100">
                            <i class="fas fa-check me-1"></i> Mark as Paid
                        </button>
                    </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Calculate total amount
function calculateTotal() {
    const amount = parseFloat(document.getElementById('amount').value) || 0;
    const taxAmount = parseFloat(document.getElementById('tax_amount').value) || 0;
    const total = amount + taxAmount;
    document.getElementById('total-amount-preview').textContent = '$' + total.toFixed(2);
}

// Event listeners
document.getElementById('amount').addEventListener('input', calculateTotal);
document.getElementById('tax_amount').addEventListener('input', calculateTotal);

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    calculateTotal();
});
</script>

@include('admin.footer')
