@include('admin.header')

@section('title', 'Create Bank Invoice')

    <a href="{{ route('admin.bank-invoices.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Invoices
    </a>

<div class="row mt-5">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Create Bank Invoice</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.bank-invoices.store') }}" method="POST">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="buyer_id" class="form-label">Buyer *</label>
                                <select name="buyer_id" id="buyer_id" class="form-select" required>
                                    <option value="">Select Buyer</option>
                                    @foreach($buyers as $buyer)
                                    <option value="{{ $buyer->id }}" {{ old('buyer_id') == $buyer->id ? 'selected' : '' }}>
                                        {{ $buyer->company_name }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('buyer_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="order_confirmation_id" class="form-label">Order Confirmation *</label>
                                <select name="order_confirmation_id" id="order_confirmation_id" class="form-select" required>
                                    <option value="">Select Order</option>
                                    @foreach($orders as $order)
                                    <option value="{{ $order->id }}" {{ old('order_confirmation_id') == $order->id ? 'selected' : '' }}>
                                        {{ $order->order_number }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('order_confirmation_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="invoice_date" class="form-label">Invoice Date *</label>
                                <input type="date" name="invoice_date" id="invoice_date" 
                                       class="form-control" value="{{ old('invoice_date', date('Y-m-d')) }}" required>
                                @error('invoice_date')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="due_date" class="form-label">Due Date *</label>
                                <input type="date" name="due_date" id="due_date" 
                                       class="form-control" value="{{ old('due_date', date('Y-m-d', strtotime('+30 days'))) }}" required>
                                @error('due_date')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount" class="form-label">Invoice Amount ($) *</label>
                                <input type="number" step="0.01" min="0.01" name="amount" id="amount" 
                                       class="form-control" value="{{ old('amount') }}" required>
                                @error('amount')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tax_amount" class="form-label">Tax Amount ($)</label>
                                <input type="number" step="0.01" min="0" name="tax_amount" id="tax_amount" 
                                       class="form-control" value="{{ old('tax_amount', 0) }}">
                                @error('tax_amount')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description *</label>
                        <textarea name="description" id="description" class="form-control" rows="4" 
                                  placeholder="Provide detailed description of goods/services..." required>{{ old('description') }}</textarea>
                        @error('description')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="bank_remarks" class="form-label">Bank Remarks</label>
                        <textarea name="bank_remarks" id="bank_remarks" class="form-control" rows="2" 
                                  placeholder="Any specific instructions for the bank...">{{ old('bank_remarks') }}</textarea>
                        @error('bank_remarks')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <button type="reset" class="btn btn-secondary">Reset</button>
                      &nbsp;  <button type="submit" class="btn btn-primary">Create Invoice</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Invoice Preview</h6>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Invoice Number:</strong><br>
                    <span class="text-muted">Auto-generated</span>
                </div>
                <div class="mb-3">
                    <strong>Total Amount:</strong><br>
                    <span id="total-amount-preview" class="fw-bold">$0.00</span>
                </div>
                <div class="mb-3">
                    <strong>Status:</strong><br>
                    <span class="badge bg-secondary text-white">Draft</span>
                </div>
                <div class="mb-3">
                    <strong>Due In:</strong><br>
                    <span id="due-days-preview" class="text-muted">-</span>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Invoice Guidelines</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled">
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Select correct buyer and order</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Provide clear description</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Set appropriate due date</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Include tax amount if applicable</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Invoice will be created as draft</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
// Calculate total amount
function calculateTotal() {
    const amount = parseFloat(document.getElementById('amount').value) || 0;
    const taxAmount = parseFloat(document.getElementById('tax_amount').value) || 0;
    const total = amount + taxAmount;
    document.getElementById('total-amount-preview').textContent = '$' + total.toFixed(2);
}

// Calculate due days
function calculateDueDays() {
    const invoiceDate = new Date(document.getElementById('invoice_date').value);
    const dueDate = new Date(document.getElementById('due_date').value);
    
    if (invoiceDate && dueDate) {
        const diffTime = dueDate - invoiceDate;
        const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
        document.getElementById('due-days-preview').textContent = diffDays + ' days';
    }
}

// Event listeners
document.getElementById('amount').addEventListener('input', calculateTotal);
document.getElementById('tax_amount').addEventListener('input', calculateTotal);
document.getElementById('invoice_date').addEventListener('change', calculateDueDays);
document.getElementById('due_date').addEventListener('change', calculateDueDays);

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    calculateTotal();
    calculateDueDays();
});
</script>
@include('admin.footer')
