@include('admin.header')

@section('title', 'Payment Allocations')

@section('actions')
    <a href="{{ route('admin.payment-allocations.create') }}" class="btn btn-primary">
        <i class="fas fa-share-alt me-1"></i> Allocate Payment
    </a>
    <a href="{{ route('admin.advance-payments.index') }}" class="btn btn-secondary">
        <i class="fas fa-money-bill-wave me-1"></i> View Payments
    </a>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Payment Allocations to Factories</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Reference</th>
                        <th>Buyer</th>
                        <th>Factory</th>
                        <th>Order</th>
                        <th>Amount</th>
                        <th>Allocation Date</th>
                        <th>Purpose</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($allocations as $allocation)
                    <tr>
                        <td>{{ $allocation->reference_number }}</td>
                        <td>{{ $allocation->advancePayment->buyer->company_name }}</td>
                        <td>{{ $allocation->factory->name }}</td>
                        <td>{{ $allocation->orderConfirmation->order_number }}</td>
                        <td class="fw-bold text-danger">${{ number_format($allocation->amount, 2) }}</td>
                        <td>{{ $allocation->allocation_date->format('M d, Y') }}</td>
                        <td>{{ Str::limit($allocation->purpose, 50) }}</td>
                        <td class="table-actions">
                            <a href="{{ route('admin.payment-allocations.show', $allocation) }}" class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="{{ route('admin.payment-allocations.edit', $allocation) }}" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.payment-allocations.destroy', $allocation) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <div class="d-flex justify-content-center">
            {{ $allocations->links() }}
        </div>
    </div>
</div>

<!-- Summary Cards -->
<div class="row mt-4">
    <div class="col-md-4">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <h6 class="card-title">Total Allocations</h6>
                <h3>{{ $allocations->total() }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h6 class="card-title">This Page Amount</h6>
                <h3>${{ number_format($allocations->sum('amount'), 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-info text-white">
            <div class="card-body">
                <h6 class="card-title">Total Factories</h6>
                <h3>{{ $allocations->unique('factory_id')->count() }}</h3>
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
