@include('admin.header')

@section('title', 'Edit Payment Allocation')

@section('actions')
    <a href="{{ route('admin.payment-allocations.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Allocations
    </a>
@endsection

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Edit Payment Allocation</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.payment-allocations.update', $paymentAllocation) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Advance Payment</label>
                                <input type="text" class="form-control" value="{{ $paymentAllocation->advancePayment->reference_number }} - {{ $paymentAllocation->advancePayment->buyer->company_name }}" readonly>
                                <input type="hidden" name="advance_payment_id" value="{{ $paymentAllocation->advance_payment_id }}">
                                <small class="form-text text-muted">
                                    Available: ${{ number_format($paymentAllocation->advancePayment->remaining_amount + $paymentAllocation->amount, 2) }}
                                </small>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="factory_id" class="form-label">Factory *</label>
                                <select name="factory_id" id="factory_id" class="form-select" required>
                                    <option value="">Select Factory</option>
                                    @foreach($factories as $factory)
                                    <option value="{{ $factory->id }}" {{ $paymentAllocation->factory_id == $factory->id ? 'selected' : '' }}>
                                        {{ $factory->name }} - {{ $factory->location }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('factory_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="order_confirmation_id" class="form-label">Order Confirmation *</label>
                                <select name="order_confirmation_id" id="order_confirmation_id" class="form-select" required>
                                    <option value="">Select Order</option>
                                    @foreach($orders as $order)
                                    <option value="{{ $order->id }}" {{ $paymentAllocation->order_confirmation_id == $order->id ? 'selected' : '' }}>
                                        {{ $order->order_number }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('order_confirmation_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount" class="form-label">Allocation Amount ($) *</label>
                                <input type="number" step="0.01" min="0.01" name="amount" id="amount" 
                                       class="form-control" value="{{ old('amount', $paymentAllocation->amount) }}" required>
                                <small class="form-text text-muted">
                                    Current: ${{ number_format($paymentAllocation->amount, 2) }} | 
                                    Available: ${{ number_format($paymentAllocation->advancePayment->remaining_amount + $paymentAllocation->amount, 2) }}
                                </small>
                                @error('amount')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="allocation_date" class="form-label">Allocation Date *</label>
                                <input type="date" name="allocation_date" id="allocation_date" 
                                       class="form-control" value="{{ old('allocation_date', $paymentAllocation->allocation_date->format('Y-m-d')) }}" required>
                                @error('allocation_date')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="purpose" class="form-label">Purpose *</label>
                        <textarea name="purpose" id="purpose" class="form-control" rows="3" required>{{ old('purpose', $paymentAllocation->purpose) }}</textarea>
                        @error('purpose')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="remarks" class="form-label">Remarks</label>
                        <textarea name="remarks" id="remarks" class="form-control" rows="2">{{ old('remarks', $paymentAllocation->remarks) }}</textarea>
                        @error('remarks')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="{{ route('admin.payment-allocations.index') }}" class="btn btn-secondary me-2">Cancel</a>
                        <button type="submit" class="btn btn-primary">Update Allocation</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Allocation Info</h6>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Reference:</strong><br>
                    {{ $paymentAllocation->reference_number }}
                </div>
                <div class="mb-3">
                    <strong>Created By:</strong><br>
                    {{ $paymentAllocation->creator->name }}<br>
                    <small class="text-muted">{{ $paymentAllocation->created_at->format('M d, Y H:i') }}</small>
                </div>
                <div class="mb-3">
                    <strong>Last Updated:</strong><br>
                    <small class="text-muted">{{ $paymentAllocation->updated_at->format('M d, Y H:i') }}</small>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Advance Payment Status</h6>
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <strong>Original Amount:</strong><br>
                    ${{ number_format($paymentAllocation->advancePayment->amount, 2) }}
                </div>
                <div class="mb-2">
                    <strong>Allocated:</strong><br>
                    ${{ number_format($paymentAllocation->advancePayment->allocated_amount, 2) }}
                </div>
                <div class="mb-2">
                    <strong>Remaining:</strong><br>
                    ${{ number_format($paymentAllocation->advancePayment->remaining_amount, 2) }}
                </div>
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
