@include('admin.header')

@section('title', 'Allocate Payment to Factory')

    <a href="{{ route('admin.payment-allocations.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Allocations
    </a>

<div class="row mt-3">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Allocate Payment to Factory</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.payment-allocations.store') }}" method="POST">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="advance_payment_id" class="form-label">Advance Payment *</label>
                                <select name="advance_payment_id" id="advance_payment_id" class="form-select" required>
                                    <option value="">Select Advance Payment</option>
                                    @foreach($advancePayments as $payment)
                                    <option value="{{ $payment->id }}" 
                                        {{ request('advance_payment_id') == $payment->id ? 'selected' : '' }}
                                        data-remaining="{{ $payment->remaining_amount }}">
                                        {{ $payment->reference_number }} - {{ $payment->buyer->company_name }} (${{ number_format($payment->remaining_amount, 2) }} available)
                                    </option>
                                    @endforeach
                                </select>
                                @error('advance_payment_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="factory_id" class="form-label">Factory *</label>
                                <select name="factory_id" id="factory_id" class="form-select" required>
                                    <option value="">Select Factory</option>
                                    @foreach($factories as $factory)
                                    <option value="{{ $factory->id }}" {{ old('factory_id') == $factory->id ? 'selected' : '' }}>
                                        {{ $factory->name }} - {{ $factory->location }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('factory_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="order_confirmation_id" class="form-label">Order Confirmation *</label>
                                <select name="order_confirmation_id" id="order_confirmation_id" class="form-select" required>
                                    <option value="">Select Order</option>
                                    @foreach($orders as $order)
                                    <option value="{{ $order->id }}" {{ old('order_confirmation_id') == $order->id ? 'selected' : '' }}>
                                        {{ $order->order_number }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('order_confirmation_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount" class="form-label">Allocation Amount ($) *</label>
                                <input type="number" step="0.01" min="0.01" name="amount" id="amount" 
                                       class="form-control" value="{{ old('amount') }}" required>
                                <small class="form-text text-muted">
                                    Available: $<span id="available-amount">0.00</span>
                                </small>
                                @error('amount')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="allocation_date" class="form-label">Allocation Date *</label>
                                <input type="date" name="allocation_date" id="allocation_date" 
                                       class="form-control" value="{{ old('allocation_date', date('Y-m-d')) }}" required>
                                @error('allocation_date')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="purpose" class="form-label">Purpose *</label>
                        <textarea name="purpose" id="purpose" class="form-control" rows="3" 
                                  placeholder="Describe the purpose of this allocation..." required>{{ old('purpose') }}</textarea>
                        @error('purpose')
                            <div class="text-danger">{{ $message }}</div>
                                @enderror
                    </div>

                    <div class="mb-3">
                        <label for="remarks" class="form-label">Remarks</label>
                        <textarea name="remarks" id="remarks" class="form-control" rows="2" 
                                  placeholder="Any additional remarks...">{{ old('remarks') }}</textarea>
                        @error('remarks')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <button type="reset" class="btn btn-secondary">Reset</button>
                        <button type="submit" class="btn btn-primary">Allocate Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Allocation Guidelines</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled">
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Select advance payment with available balance</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Allocation amount cannot exceed available balance</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Provide clear purpose for tracking</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Allocations are irreversible once saved</li>
                </ul>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Available Payments</h6>
            </div>
            <div class="card-body">
                @if($advancePayments->count() > 0)
                    @foreach($advancePayments as $payment)
                    <div class="border-bottom pb-2 mb-2">
                        <small class="fw-bold">{{ $payment->reference_number }}</small><br>
                        <small>{{ $payment->buyer->company_name }}</small><br>
                        <small class="text-success">Available: ${{ number_format($payment->remaining_amount, 2) }}</small>
                    </div>
                    @endforeach
                @else
                    <div class="text-center text-muted">
                        <i class="fas fa-exclamation-triangle fa-2x mb-2"></i>
                        <p>No advance payments with available balance</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('advance_payment_id').addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex];
    const remainingAmount = selectedOption.getAttribute('data-remaining') || 0;
    document.getElementById('available-amount').textContent = parseFloat(remainingAmount).toFixed(2);
    
    // Set max value for amount input
    const amountInput = document.getElementById('amount');
    amountInput.setAttribute('max', remainingAmount);
});

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    const advanceSelect = document.getElementById('advance_payment_id');
    if (advanceSelect.value) {
        advanceSelect.dispatchEvent(new Event('change'));
    }
});
</script>
@include('admin.footer')
