@include('admin.header')

@section('title', 'Advance Payment Details')

    <a href="{{ route('admin.advance-payments.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Payments
    </a>
    <a href="{{ route('admin.advance-payments.edit', $advancePayment) }}" class="btn btn-warning">
        <i class="fas fa-edit me-1"></i> Edit
    </a>
    @if($advancePayment->canAllocate())
    <a href="{{ route('admin.payment-allocations.create') }}?advance_payment_id={{ $advancePayment->id }}" 
       class="btn btn-success">
        <i class="fas fa-share-alt me-1"></i> Allocate to Factory
    </a>
    @endif

<div class="row mt-5">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Payment Details</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Reference Number</th>
                                <td>{{ $advancePayment->reference_number }}</td>
                            </tr>
                            <tr>
                                <th>Buyer</th>
                                <td>{{ $advancePayment->buyer->contact_person }}</td>
                            </tr>
                            <tr>
                                <th>Order Confirmation</th>
                                <td>{{ $advancePayment->orderConfirmation->order_number ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Amount</th>
                                <td class="fw-bold text-success">${{ number_format($advancePayment->amount, 2) }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Payment Date</th>
                                <td>{{ $advancePayment->payment_date->format('M d, Y') }}</td>
                            </tr>
                            <tr>
                                <th>Payment Method</th>
                                <td class="text-uppercase">{{ $advancePayment->payment_method }}</td>
                            </tr>
                            <tr>
                                <th>Transaction ID</th>
                                <td>{{ $advancePayment->transaction_id ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    <span class="badge bg-{{ $advancePayment->status_badge_color }}">
                                        {{ ucfirst($advancePayment->status) }}
                                    </span>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Allocated Amount</th>
                                <td class="fw-bold text-danger">${{ number_format($advancePayment->allocated_amount, 2) }}</td>
                            </tr>
                            <tr>
                                <th>Remaining Amount</th>
                                <td class="fw-bold text-success">${{ number_format($advancePayment->remaining_amount, 2) }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Created By</th>
                                <td>{{ $advancePayment->creator->name }}</td>
                            </tr>
                            <tr>
                                <th>Created At</th>
                                <td>{{ $advancePayment->created_at->format('M d, Y H:i') }}</td>
                            </tr>
                        </table>
                    </div>
                </div>

                @if($advancePayment->remarks)
                <div class="row">
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Remarks</label>
                            <div class="border p-3 bg-light rounded">
                                {{ $advancePayment->remarks }}
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>

        <!-- Allocations Section -->
        @if($advancePayment->allocations->count() > 0)
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Payment Allocations</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm table-hover">
                        <thead>
                            <tr>
                                <th>Reference</th>
                                <th>Factory</th>
                                <th>Order</th>
                                <th>Amount</th>
                                <th>Date</th>
                                <th>Purpose</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($advancePayment->allocations as $allocation)
                            <tr>
                                <td>{{ $allocation->reference_number }}</td>
                                <td>{{ $allocation->factory->name }}</td>
                                <td>{{ $allocation->orderConfirmation->order_number }}</td>
                                <td class="text-danger">${{ number_format($allocation->amount, 2) }}</td>
                                <td>{{ $allocation->allocation_date->format('M d, Y') }}</td>
                                <td>{{ Str::limit($allocation->purpose, 50) }}</td>
                                <td>
                                    <a href="{{ route('admin.payment-allocations.show', $allocation) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Buyer Information</h6>
            </div>
            <div class="card-body">
                <h6>{{ $advancePayment->buyer->company_name }}</h6>
                <ul class="list-unstyled">
                    <li><strong>Contact:</strong> {{ $advancePayment->buyer->contact_person }}</li>
                    <li><strong>Email:</strong> {{ $advancePayment->buyer->email }}</li>
                    <li><strong>Phone:</strong> {{ $advancePayment->buyer->phone }}</li>
                    <li><strong>Address:</strong> {{ $advancePayment->buyer->address }}</li>
                </ul>
                
                <a href="{{ route('admin.payment.ledger.buyer', $advancePayment->buyer) }}" class="btn btn-sm btn-outline-primary">
                    View Buyer Ledger
                </a>
            </div>
        </div>
        
        @if($advancePayment->orderConfirmation)
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Order Information</h6>
            </div>
            <div class="card-body">
                <h6>{{ $advancePayment->orderConfirmation->order_number }}</h6>
                <ul class="list-unstyled">
                    <li><strong>Quantity:</strong> {{ number_format($advancePayment->orderConfirmation->confirmed_quantity) }}</li>
                    <li><strong>Price:</strong> ${{ number_format($advancePayment->orderConfirmation->confirmed_price, 2) }}</li>
                    <li><strong>Delivery:</strong> {{ $advancePayment->orderConfirmation->formatted_delivery_date }}</li>
                    <li><strong>Status:</strong> 
                        <span class="badge bg-{{ $advancePayment->orderConfirmation->status_badge_color }}">
                            {{ ucfirst($advancePayment->orderConfirmation->status) }}
                        </span>
                    </li>
                </ul>
            </div>
        </div>
        @endif
    </div>
</div>
@include('admin.footer')
