@include('admin.header')

@section('title', 'Payment Ledger')

    <a href="{{ route('admin.advance-payments.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Payments
    </a>
    <form action="{{ route('admin.payment-ledger.update-all') }}" method="POST" class="d-inline">
        @csrf
        <button type="submit" class="btn btn-warning">
            <i class="fas fa-sync-alt me-1"></i> Update All Ledgers
        </button>
    </form>

<div class="row mt-5">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Payment Ledger - Summary</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead class="table-dark">
                            <tr>
                                <th>Buyer</th>
                                <th>Total In ($)</th>
                                <th>Total Out ($)</th>
                                <th>Current Balance ($)</th>
                                <th>Last Updated</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($buyers as $buyer)
                            @php $ledger = $buyer->ledger @endphp
                            <tr>
                                <td>{{ $buyer->company_name }}</td>
                                <td class="text-success fw-bold">${{ number_format($ledger->total_in ?? 0, 2) }}</td>
                                <td class="text-danger fw-bold">${{ number_format($ledger->total_out ?? 0, 2) }}</td>
                                <td class="fw-bold {{ ($ledger->current_balance ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                                    ${{ number_format($ledger->current_balance ?? 0, 2) }}
                                </td>
                                <td>{{ $ledger->last_updated->format('M d, Y H:i') ?? 'N/A' }}</td>
                                <td>
                                    <a href="{{ route('admin.payment.ledger.buyer', $buyer) }}" class="btn btn-sm btn-primary">
                                        <i class="fas fa-list me-1"></i> Details
                                    </a>
                                    <a href="{{ route('admin.payment-ledger.buyer-report', $buyer) }}" class="btn btn-sm btn-info" target="_blank">
                                        <i class="fas fa-download me-1"></i> PDF
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Summary Cards -->
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <h6 class="card-title">Total Payments</h6>
                <h3>${{ number_format($buyers->sum('ledger.total_in'), 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h6 class="card-title">Total Allocations</h6>
                <h3>${{ number_format($buyers->sum('ledger.total_out'), 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <h6 class="card-title">Net Balance</h6>
                <h3>${{ number_format($buyers->sum('ledger.current_balance'), 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-dark">
            <div class="card-body">
                <h6 class="card-title">Active Buyers</h6>
                <h3>{{ $buyers->count() }}</h3>
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
