@include('admin.header')

@section('title', 'Advance Payments')

    <a href="{{ route('admin.advance-payments.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-1"></i> Log Advance Payment
    </a>
    <a href="{{ route('admin.payment.ledger') }}" class="btn btn-info">
        <i class="fas fa-book me-1"></i> View Ledger
    </a>

<div class="card mt-5">
    <div class="card-header">
        <h5 class="card-title mb-0">Advance Payment Tracker</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Reference</th>
                        <th>Buyer</th>
                        <th>Order</th>
                        <th>Amount</th>
                        <th>Payment Date</th>
                        <th>Method</th>
                        <th>Status</th>
                        <th>Remaining</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($advancePayments as $payment)
                    <tr>
                        <td>{{ $payment->reference_number }}</td>
                        <td>{{ $payment->buyer->contact_person }}</td>
                        <td>{{ $payment->orderConfirmation->order_number ?? 'N/A' }}</td>
                        <td>${{ number_format($payment->amount, 2) }}</td>
                        <td>{{ $payment->payment_date->format('M d, Y') }}</td>
                        <td>
                            <span class="badge bg-info text-dark text-uppercase">
                                {{ $payment->payment_method }}
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-{{ $payment->status_badge_color }} status-badge">
                                {{ ucfirst($payment->status) }}
                            </span>
                        </td>
                        <td>
                            <span class="fw-bold text-{{ $payment->remaining_amount > 0 ? 'success' : 'secondary' }}">
                                ${{ number_format($payment->remaining_amount, 2) }}
                            </span>
                        </td>
                        <td class="table-actions">
                            <a href="{{ route('admin.advance-payments.show', $payment) }}" class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="{{ route('admin.advance-payments.edit', $payment) }}" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            @if($payment->canAllocate())
                            <a href="{{ route('admin.payment-allocations.create') }}?advance_payment_id={{ $payment->id }}" 
                               class="btn btn-sm btn-success" title="Allocate to Factory">
                                <i class="fas fa-share-alt"></i>
                            </a>
                            @endif
                            <form action="{{ route('admin.advance-payments.destroy', $payment) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <div class="d-flex justify-content-center">
            {{ $advancePayments->links() }}
        </div>
    </div>
</div>
@include('admin.footer')
