@include('admin.header')

@section('title', 'Edit Advance Payment')

@section('actions')
    <a href="{{ route('admin.advance-payments.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Payments
    </a>
@endsection

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Edit Advance Payment</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.advance-payments.update', $advancePayment) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="buyer_id" class="form-label">Buyer *</label>
                                <select name="buyer_id" id="buyer_id" class="form-select" required>
                                    <option value="">Select Buyer</option>
                                    @foreach($buyers as $buyer)
                                    <option value="{{ $buyer->id }}" {{ $advancePayment->buyer_id == $buyer->id ? 'selected' : '' }}>
                                        {{ $buyer->company_name }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('buyer_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="order_confirmation_id" class="form-label">Order Confirmation</label>
                                <select name="order_confirmation_id" id="order_confirmation_id" class="form-select">
                                    <option value="">Select Order (Optional)</option>
                                    @foreach($orders as $order)
                                    <option value="{{ $order->id }}" {{ $advancePayment->order_confirmation_id == $order->id ? 'selected' : '' }}>
                                        {{ $order->order_number }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('order_confirmation_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount" class="form-label">Amount (₹) *</label>
                                <input type="number" step="0.01" min="0.01" name="amount" id="amount" 
                                       class="form-control" value="{{ old('amount', $advancePayment->amount) }}" required>
                                @error('amount')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="payment_date" class="form-label">Payment Date *</label>
                                <input type="date" name="payment_date" id="payment_date" 
                                       class="form-control" value="{{ old('payment_date', $advancePayment->payment_date->format('Y-m-d')) }}" required>
                                @error('payment_date')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="payment_method" class="form-label">Payment Method *</label>
                                <select name="payment_method" id="payment_method" class="form-select" required>
                                    <option value="">Select Method</option>
                                    <option value="bank_transfer" {{ $advancePayment->payment_method == 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                                    <option value="lc" {{ $advancePayment->payment_method == 'lc' ? 'selected' : '' }}>LC (Letter of Credit)</option>
                                    <option value="tt" {{ $advancePayment->payment_method == 'tt' ? 'selected' : '' }}>TT (Telegraphic Transfer)</option>
                                    <option value="cash" {{ $advancePayment->payment_method == 'cash' ? 'selected' : '' }}>Cash</option>
                                    <option value="cheque" {{ $advancePayment->payment_method == 'cheque' ? 'selected' : '' }}>Cheque</option>
                                </select>
                                @error('payment_method')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="transaction_id" class="form-label">Transaction ID</label>
                                <input type="text" name="transaction_id" id="transaction_id" 
                                       class="form-control" value="{{ old('transaction_id', $advancePayment->transaction_id) }}" 
                                       placeholder="Bank transaction reference">
                                @error('transaction_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status" class="form-label">Status *</label>
                                <select name="status" id="status" class="form-select" required>
                                    <option value="pending" {{ $advancePayment->status == 'pending' ? 'selected' : '' }}>Pending</option>
                                    <option value="received" {{ $advancePayment->status == 'received' ? 'selected' : '' }}>Received</option>
                                    <option value="cancelled" {{ $advancePayment->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                </select>
                                @error('status')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="remarks" class="form-label">Remarks</label>
                        <textarea name="remarks" id="remarks" class="form-control" rows="3">{{ old('remarks', $advancePayment->remarks) }}</textarea>
                        @error('remarks')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="{{ route('admin.advance-payments.index') }}" class="btn btn-secondary me-2">Cancel</a>
                        <button type="submit" class="btn btn-primary">Update Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Payment Summary</h6>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Reference Number:</strong><br>
                    {{ $advancePayment->reference_number }}
                </div>
                <div class="mb-3">
                    <strong>Allocated Amount:</strong><br>
                    ₹{{ number_format($advancePayment->allocated_amount, 2) }}
                </div>
                <div class="mb-3">
                    <strong>Remaining Amount:</strong><br>
                    ₹{{ number_format($advancePayment->remaining_amount, 2) }}
                </div>
                <div class="mb-3">
                    <strong>Created By:</strong><br>
                    {{ $advancePayment->creator->name }}<br>
                    <small class="text-muted">{{ $advancePayment->created_at->format('M d, Y H:i') }}</small>
                </div>
                <div class="mb-3">
                    <strong>Last Updated:</strong><br>
                    <small class="text-muted">{{ $advancePayment->updated_at->format('M d, Y H:i') }}</small>
                </div>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Allocation Status</h6>
            </div>
            <div class="card-body">
                @if($advancePayment->allocations->count() > 0)
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    This payment has {{ $advancePayment->allocations->count() }} allocation(s).
                </div>
                @else
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    No allocations made from this payment.
                </div>
                @endif
                
                @if($advancePayment->canAllocate())
                <a href="{{ route('admin.payment-allocations.create') }}?advance_payment_id={{ $advancePayment->id }}" 
                   class="btn btn-success btn-sm w-100">
                    <i class="fas fa-share-alt me-1"></i> Allocate to Factory
                </a>
                @endif
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
