@include('admin.header')

@section('title', 'Log Advance Payment')

@section('actions')
    <a href="{{ route('admin.advance-payments.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Payments
    </a>
@endsection

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Log Advance Payment</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.advance-payments.store') }}" method="POST">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="buyer_id" class="form-label">Buyer *</label>
                                <select name="buyer_id" id="buyer_id" class="form-select" required>
                                    <option value="">Select Buyer</option>
                                    @foreach($buyers as $buyer)
                                    <option value="{{ $buyer->id }}" {{ old('buyer_id') == $buyer->id ? 'selected' : '' }}>
                                        {{ $buyer->contact_person }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('buyer_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="order_confirmation_id" class="form-label">Order Confirmation</label>
                                <select name="order_confirmation_id" id="order_confirmation_id" class="form-select">
                                    <option value="">Select Order (Optional)</option>
                                    @foreach($orders as $order)
                                    <option value="{{ $order->id }}" {{ old('order_confirmation_id') == $order->id ? 'selected' : '' }}>
                                        {{ $order->order_number }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('order_confirmation_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount" class="form-label">Amount ($) *</label>
                                <input type="number" step="0.01" min="0.01" name="amount" id="amount" 
                                       class="form-control" value="{{ old('amount') }}" required>
                                @error('amount')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="payment_date" class="form-label">Payment Date *</label>
                                <input type="date" name="payment_date" id="payment_date" 
                                       class="form-control" value="{{ old('payment_date', date('Y-m-d')) }}" required>
                                @error('payment_date')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="payment_method" class="form-label">Payment Method *</label>
                                <select name="payment_method" id="payment_method" class="form-select" required>
                                    <option value="">Select Method</option>
                                    <option value="bank_transfer" {{ old('payment_method') == 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                                    <option value="lc" {{ old('payment_method') == 'lc' ? 'selected' : '' }}>LC (Letter of Credit)</option>
                                    <option value="tt" {{ old('payment_method') == 'tt' ? 'selected' : '' }}>TT (Telegraphic Transfer)</option>
                                    <option value="cash" {{ old('payment_method') == 'cash' ? 'selected' : '' }}>Cash</option>
                                    <option value="cheque" {{ old('payment_method') == 'cheque' ? 'selected' : '' }}>Cheque</option>
                                </select>
                                @error('payment_method')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="transaction_id" class="form-label">Transaction ID</label>
                                <input type="text" name="transaction_id" id="transaction_id" 
                                       class="form-control" value="{{ old('transaction_id') }}" 
                                       placeholder="Bank transaction reference">
                                @error('transaction_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="remarks" class="form-label">Remarks</label>
                        <textarea name="remarks" id="remarks" class="form-control" rows="3" 
                                  placeholder="Any additional remarks...">{{ old('remarks') }}</textarea>
                        @error('remarks')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <button type="reset" class="btn btn-secondary">Reset</button>
                        <button type="submit" class="btn btn-primary">Log Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Payment Guidelines</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled">
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Select the correct buyer</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Link to order confirmation if applicable</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Provide accurate payment details</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Include transaction ID for bank payments</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Payment will be marked as "received" by default</li>
                </ul>
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
