@include('admin.header')

@section('title', $buyer->company_name . ' - Payment Ledger')

    <a href="{{ route('admin.payment.ledger') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Ledger
    </a>
    <a href="{{ route('admin.advance-payments.create') }}?buyer_id={{ $buyer->id }}" class="btn btn-primary">
        <i class="fas fa-plus me-1"></i> Add Payment
    </a>
    <a href="{{ route('admin.payment-ledger.buyer-report', $buyer) }}" class="btn btn-info" target="_blank">
        <i class="fas fa-download me-1"></i> Export PDF
    </a>

<div class="row mt-5">
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Ledger Summary</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Buyer:</strong> {{ $buyer->contact_person }}
                </div>
                <div class="mb-2">
                    <strong>Total Payments In:</strong>
                    <span class="float-end text-success fw-bold">${{ number_format($ledger->total_in, 2) }}</span>
                </div>
                <div class="mb-2">
                    <strong>Total Allocations Out:</strong>
                    <span class="float-end text-danger fw-bold">${{ number_format($ledger->total_out, 2) }}</span>
                </div>
                <div class="mb-2">
                    <strong>Current Balance:</strong>
                    <span class="float-end fw-bold {{ $ledger->current_balance >= 0 ? 'text-success' : 'text-danger' }}">
                        ${{ number_format($ledger->current_balance, 2) }}
                    </span>
                </div>
                <div class="mt-3">
                    <small class="text-muted">Last Updated: {{ $ledger->last_updated->format('M d, Y H:i') }}</small>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Buyer Information</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled">
                    <li><strong>Contact:</strong> {{ $buyer->contact_person }}</li>
                    <li><strong>Email:</strong> {{ $buyer->email }}</li>
                    <li><strong>Phone:</strong> {{ $buyer->phone }}</li>
                    <li><strong>Address:</strong> {{ $buyer->address }}</li>
                </ul>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Payment History</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Reference</th>
                                <th>Order</th>
                                <th>Amount</th>
                                <th>Allocated</th>
                                <th>Balance</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($advancePayments as $payment)
                            <tr>
                                <td>{{ $payment->payment_date->format('M d, Y') }}</td>
                                <td>
                                    <a href="{{ route('admin.advance-payments.show', $payment) }}" class="text-decoration-none">
                                        {{ $payment->reference_number }}
                                    </a>
                                </td>
                                <td>{{ $payment->orderConfirmation->order_number ?? 'N/A' }}</td>
                                <td class="text-success">${{ number_format($payment->amount, 2) }}</td>
                                <td class="text-danger">${{ number_format($payment->allocated_amount, 2) }}</td>
                                <td class="fw-bold {{ $payment->remaining_amount > 0 ? 'text-success' : 'text-secondary' }}">
                                    ${{ number_format($payment->remaining_amount, 2) }}
                                </td>
                                <td>
                                    <span class="badge bg-{{ $payment->status_badge_color }} status-badge">
                                        {{ ucfirst($payment->status) }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('admin.advance-payments.show', $payment) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Allocation History</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Reference</th>
                                <th>Factory</th>
                                <th>Order</th>
                                <th>Amount</th>
                                <th>Purpose</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $allocations = \App\Models\PaymentAllocation::whereHas('advancePayment', function($q) use ($buyer) {
                                    $q->where('buyer_id', $buyer->id);
                                })->with(['factory', 'orderConfirmation'])->latest()->get();
                            @endphp
                            
                            @foreach($allocations as $allocation)
                            <tr>
                                <td>{{ $allocation->allocation_date->format('M d, Y') }}</td>
                                <td>{{ $allocation->reference_number }}</td>
                                <td>{{ $allocation->factory->name }}</td>
                                <td>{{ $allocation->orderConfirmation->order_number }}</td>
                                <td class="text-danger">${{ number_format($allocation->amount, 2) }}</td>
                                <td>{{ Str::limit($allocation->purpose, 50) }}</td>
                                <td>
                                    <a href="{{ route('admin.payment-allocations.show', $allocation) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                            
                            @if($allocations->isEmpty())
                            <tr>
                                <td colspan="7" class="text-center text-muted">No allocations found</td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
