@include('admin.header')

<div class='container'>
    <div class='row'>
        <div class='col-md-8 offset-md-2'>
            <div class='card shadow'>
                <div class='card-header bg-primary text-white'>
                    <h4 class='mb-0'>
                        <i class='fas fa-file-alt me-2'></i>Document Details - {{ $document->file_name }}
                    </h4>
                </div>
                <div class='card-body'>
                    <div class='row mb-3'>
                        <div class='col-md-6'>
                            <strong>File Name:</strong> {{ $document->file_name }}<br>
                            <strong>Category:</strong> <span class='badge bg-info'>{{ ucfirst(str_replace('_', ' ', $document->category)) }}</span><br>
                            <strong>Size:</strong> {{ number_format($document->file_size / 1024, 2) }} KB<br>
                            <strong>MIME Type:</strong> {{ $document->mime_type }}<br>
                        </div>
                        <div class='col-md-6'>
                            <strong>Uploaded By:</strong> {{ $document->uploader->name ?? 'N/A' }}<br>
                            <strong>Uploaded At:</strong> {{ $document->created_at->format('Y-m-d H:i') }}<br>
                            <strong>Last Updated:</strong> {{ $document->updated_at->format('Y-m-d H:i') }}<br>
                            <strong>Order Confirmation:</strong> 
                                <a href='{{ route('admin.order-confirmations.show', $document->orderConfirmation->id) }}' class='text-decoration-none'>
                                    #{{ $document->orderConfirmation->order_number ?? $document->orderConfirmation->id }}
                                </a>
                        </div>
                    </div>

                    <div class='mb-3'>
                        <strong>Notes:</strong><br>
                        <p>{{ $document->notes ?? 'N/A' }}</p>
                    </div>

                    <div class='d-flex justify-content-between'>
                        <a href='{{ route('admin.order-documents.index', ['order_confirmation_id' => $document->order_confirmation_id]) }}' 
                           class='btn btn-secondary'>
                            <i class='fas fa-arrow-left me-1'></i>Back to Documents
                        </a>
                        <div>
                            <a href='{{ route('admin.order-documents.download', $document->id) }}' class='btn btn-success me-2'>
                                <i class='fas fa-download me-1'></i>Download
                            </a>
                            <a href='{{ route('admin.order-documents.edit', $document->id) }}' class='btn btn-warning me-2'>
                                <i class='fas fa-edit me-1'></i>Edit
                            </a>
                            <form action='{{ route('admin.order-documents.destroy', $document->id) }}' method='POST'
                                  style='display:inline-block;'>
                                @csrf
                                @method('DELETE')
                                <button type='submit' class='btn btn-danger'
                                        onclick='return confirm("Are you sure you want to delete this document?")'>
                                    <i class='fas fa-trash me-1'></i>Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.footer')

