@include('admin.header')

<div class='container'>
    <div class='row mb-3'>
        <div class='col-md-6'>
            <h1><i class='fas fa-file-alt me-2'></i>Order Documents</h1>
        </div>
        <div class='col-md-6 text-end'>
            <a href='{{ route('admin.order-documents.create', ['order_confirmation_id' => request('order_confirmation_id')]) }}' class='btn btn-primary'>
                <i class='fas fa-plus me-1'></i>Upload New Document
            </a>
        </div>
    </div>

    @if (session('success'))
        <div class='alert alert-success alert-dismissible fade show'>
            <i class='fas fa-check-circle me-2'></i>{{ session('success') }}
            <button type='button' class='btn-close' data-bs-dismiss='alert'></button>
        </div>
    @endif
    @if (session('error'))
        <div class='alert alert-danger alert-dismissible fade show'>
            <i class='fas fa-exclamation-circle me-2'></i>{{ session('error') }}
            <button type='button' class='btn-close' data-bs-dismiss='alert'></button>
        </div>
    @endif

    <div class='card'>
        <div class='card-body'>
            @if($orderConfirmation)
                <h5 class='mb-3'>Documents for Order Confirmation: 
                    <a href='{{ route('admin.order-confirmations.show', $orderConfirmation->id) }}'>
                        #{{ $orderConfirmation->order_number ?? $orderConfirmation->id }}
                    </a>
                </h5>
            @endif

            <div class='table-responsive'>
                <table class='table table-bordered table-striped'>
                    <thead class='table-dark'>
                        <tr>
                            <th>ID</th>
                            <th>File Name</th>
                            <th>Category</th>
                            <th>Size</th>
                            <th>Uploaded By</th>
                            <th>Uploaded At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($documents as $document)
                            <tr>
                                <td>{{ $document->id }}</td>
                                <td>{{ $document->file_name }}</td>
                                <td><span class='badge bg-info'>{{ ucfirst(str_replace('_', ' ', $document->category)) }}</span></td>
                                <td>{{ number_format($document->file_size / 1024, 2) }} KB</td>
                                <td>{{ $document->uploader->name ?? 'N/A' }}</td>
                                <td>{{ $document->created_at->format('Y-m-d H:i') }}</td>
                                <td>
                                    <div class='btn-group' role='group'>
                                        <a href='{{ route('admin.order-documents.download', $document->id) }}' class='btn btn-success btn-sm' title='Download'>
                                            <i class='fas fa-download'></i>
                                        </a>
                                        <a href='{{ route('admin.order-documents.edit', $document->id) }}' class='btn btn-warning btn-sm' title='Edit'>
                                            <i class='fas fa-edit'></i>
                                        </a>
                                        <form action='{{ route('admin.order-documents.destroy', $document->id) }}' method='POST' style='display:inline-block;'>
                                            @csrf
                                            @method('DELETE')
                                            <button type='submit' class='btn btn-danger btn-sm' 
                                                    onclick='return confirm("Are you sure you want to delete this document?")' title='Delete'>
                                                <i class='fas fa-trash'></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan='7' class='text-center py-4'>
                                    <i class='fas fa-folder-open fa-3x text-muted mb-3'></i>
                                    <p class='text-muted'>No documents found for this order confirmation.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@include('admin.footer')

