@include('admin.header')

<div class='container'>
    <div class='row'>
        <div class='col-md-8 offset-md-2'>
            <div class='card shadow'>
                <div class='card-header bg-primary text-white'>
                    <h4 class='mb-0'>
                        <i class='fas fa-edit me-2'></i>
                        Edit Document - {{ $orderDocument->file_name }}
                    </h4>
                </div>
                <div class='card-body'>
                    @if (session('success'))
                        <div class='alert alert-success alert-dismissible fade show'>
                            <i class='fas fa-check-circle me-2'></i>{{ session('success') }}
                            <button type='button' class='btn-close' data-bs-dismiss='alert'></button>
                        </div>
                    @endif
                    @if (session('error'))
                        <div class='alert alert-danger alert-dismissible fade show'>
                            <i class='fas fa-exclamation-circle me-2'></i>{{ session('error') }}
                            <button type='button' class='btn-close' data-bs-dismiss='alert'></button>
                        </div>
                    @endif

                    <form action='{{ route('admin.order-documents.update', $orderDocument->id) }}' method='POST'>
                        @csrf
                        @method('PUT')

                        <div class='mb-3'>
                            <label for='category' class='form-label'>
                                <i class='fas fa-tag me-1'></i>Document Category <span class='text-danger'>*</span>
                            </label>
                            <select class='form-select @error('category') is-invalid @enderror' 
                                    id='category' name='category' required>
                                <option value=''>Select Category</option>
                                <option value='purchase_order' {{ (old('category', $orderDocument->category) == 'purchase_order') ? 'selected' : '' }}>
                                    Purchase Order
                                </option>
                                <option value='invoice' {{ (old('category', $orderDocument->category) == 'invoice') ? 'selected' : '' }}>
                                    Invoice
                                </option>
                                <option value='packing_list' {{ (old('category', $orderDocument->category) == 'packing_list') ? 'selected' : '' }}>
                                    Packing List
                                </option>
                                <option value='shipping_document' {{ (old('category', $orderDocument->category) == 'shipping_document') ? 'selected' : '' }}>
                                    Shipping Document
                                </option>
                                <option value='quality_certificate' {{ (old('category', $orderDocument->category) == 'quality_certificate') ? 'selected' : '' }}>
                                    Quality Certificate
                                </option>
                                <option value='other' {{ (old('category', $orderDocument->category) == 'other') ? 'selected' : '' }}>
                                    Other
                                </option>
                            </select>
                            @error('category')
                                <div class='invalid-feedback'>{{ $message }}</div>
                            @enderror
                        </div>

                        <div class='mb-3'>
                            <label for='notes' class='form-label'>
                                <i class='fas fa-sticky-note me-1'></i>Notes (Optional)
                            </label>
                            <textarea class='form-control @error('notes') is-invalid @enderror' 
                                      id='notes' name='notes' rows='3' 
                                      placeholder='Add any additional notes about this document...'>{{ old('notes', $orderDocument->notes) }}</textarea>
                            @error('notes')
                                <div class='invalid-feedback'>{{ $message }}</div>
                            @enderror
                        </div>

                        <div class='d-flex justify-content-between'>
                            <a href='{{ route('admin.order-documents.show', $orderDocument->id) }}' 
                               class='btn btn-secondary'>
                                <i class='fas fa-arrow-left me-1'></i>Back to Document Details
                            </a>
                            <button type='submit' class='btn btn-primary'>
                                <i class='fas fa-save me-1'></i>Update Document
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Document Summary -->
            <div class='card mt-4'>
                <div class='card-header bg-light'>
                    <h6 class='mb-0'>
                        <i class='fas fa-info-circle me-2'></i>
                        Document Summary
                    </h6>
                </div>
                <div class='card-body'>
                    <div class='row'>
                        <div class='col-md-6'>
                            <p><strong>File Name:</strong> {{ $orderDocument->file_name }}</p>
                            <p><strong>Size:</strong> {{ number_format($orderDocument->file_size / 1024, 2) }} KB</p>
                        </div>
                        <div class='col-md-6'>
                            <p><strong>Uploaded By:</strong> {{ $orderDocument->uploader->name ?? 'N/A' }}</p>
                            <p><strong>Uploaded At:</strong> {{ $orderDocument->created_at->format('M d, Y H:i') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.footer')

