@include('admin.header')

<div class='container'>
    <div class='row'>
        <div class='col-md-8 offset-md-2'>
            <div class='card shadow'>
                <div class='card-header bg-primary text-white'>
                    <h4 class='mb-0'>
                        <i class='fas fa-upload me-2'></i>
                        Upload Document for Order Confirmation #{{ $orderConfirmation->order_number }}
                    </h4>
                </div>
                <div class='card-body'>
                    @if (session('success'))
                        <div class='alert alert-success alert-dismissible fade show'>
                            <i class='fas fa-check-circle me-2'></i>{{ session('success') }}
                            <button type='button' class='btn-close' data-bs-dismiss='alert'></button>
                        </div>
                    @endif
                    @if (session('error'))
                        <div class='alert alert-danger alert-dismissible fade show'>
                            <i class='fas fa-exclamation-circle me-2'></i>{{ session('error') }}
                            <button type='button' class='btn-close' data-bs-dismiss='alert'></button>
                        </div>
                    @endif

                    <form action='{{ route('admin.order-documents.store') }}' method='POST' enctype='multipart/form-data'>
                        @csrf
                        <input type='hidden' name='order_confirmation_id' value='{{ $orderConfirmation->id }}'>

                        <div class='mb-3'>
                            <label for='document_file' class='form-label'>
                                <i class='fas fa-file me-1'></i>Document File <span class='text-danger'>*</span>
                            </label>
                            <input type='file' class='form-control @error('document_file') is-invalid @enderror' 
                                   id='document_file' name='document_file' required 
                                   accept='.pdf,.doc,.docx,.xls,.xlsx,.jpg,.jpeg,.png'>
                            <div class='form-text'>
                                Supported formats: PDF, DOC, DOCX, XLS, XLSX, JPG, JPEG, PNG (Max: 30MB)
                            </div>
                            @error('document_file')
                                <div class='invalid-feedback'>{{ $message }}</div>
                            @enderror
                        </div>

                        <div class='mb-3'>
                            <label for='category' class='form-label'>
                                <i class='fas fa-tag me-1'></i>Document Category <span class='text-danger'>*</span>
                            </label>
                      <select class='form-select @error('document_type') is-invalid @enderror' 
        id='document_type' name='document_type' required>
    <option value=''>Select Category</option>
    <option value='purchase_order' {{ old('document_type') == 'purchase_order' ? 'selected' : '' }}>
        Purchase Order
    </option>
    <option value='invoice' {{ old('document_type') == 'invoice' ? 'selected' : '' }}>
        Invoice
    </option>
    <option value='packing_list' {{ old('document_type') == 'packing_list' ? 'selected' : '' }}>
        Packing List
    </option>
    <option value='shipping_document' {{ old('document_type') == 'shipping_document' ? 'selected' : '' }}>
        Shipping Document
    </option>
    <option value='quality_certificate' {{ old('document_type') == 'quality_certificate' ? 'selected' : '' }}>
        Quality Certificate
    </option>
    <option value='other' {{ old('document_type') == 'other' ? 'selected' : '' }}>
        Other
    </option>
</select>
@error('document_type')
    <div class='invalid-feedback'>{{ $message }}</div>
@enderror

                        </div>

                        <div class='mb-3'>
                            <label for='notes' class='form-label'>
                                <i class='fas fa-sticky-note me-1'></i>Notes (Optional)
                            </label>
                            <textarea class='form-control @error('notes') is-invalid @enderror' 
                                      id='notes' name='notes' rows='3' 
                                      placeholder='Add any additional notes about this document...'>{{ old('notes') }}</textarea>
                            @error('notes')
                                <div class='invalid-feedback'>{{ $message }}</div>
                            @enderror
                        </div>

                        <div class='d-flex justify-content-between'>
                            <a href='{{ route('admin.order-confirmations.show', $orderConfirmation->id) }}' 
                               class='btn btn-secondary'>
                                <i class='fas fa-arrow-left me-1'></i>Back to Order Confirmation
                            </a>
                            <button type='submit' class='btn btn-primary'>
                                <i class='fas fa-upload me-1'></i>Upload Document
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Order Confirmation Summary -->
            <div class='card mt-4'>
                <div class='card-header bg-light'>
                    <h6 class='mb-0'>
                        <i class='fas fa-info-circle me-2'></i>
                        Order Confirmation Summary
                    </h6>
                </div>
                <div class='card-body'>
                    <div class='row'>
                        <div class='col-md-6'>
                            <p><strong>Order Number:</strong> {{ $orderConfirmation->order_number }}</p>
                            <p><strong>Customer PO:</strong> {{ $orderConfirmation->customer_po_number ?? 'N/A' }}</p>
                            <p><strong>Confirmed Quantity:</strong> {{ number_format($orderConfirmation->confirmed_quantity) }}</p>
                        </div>
                        <div class='col-md-6'>
                            <p><strong>Confirmed Price:</strong> ${{ number_format($orderConfirmation->confirmed_price, 2) }}</p>
                            <p><strong>Delivery Date:</strong> {{ $orderConfirmation->delivery_date ? \Carbon\Carbon::parse($orderConfirmation->delivery_date)->format('M d, Y') : 'N/A' }}</p>
                            <p><strong>Status:</strong> 
                                <span class='badge bg-{{ $orderConfirmation->status == 'pending' ? 'warning' : ($orderConfirmation->status == 'confirmed' ? 'success' : 'secondary') }}'>
                                    {{ ucfirst($orderConfirmation->status) }}
                                </span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// File size validation
document.getElementById('document_file').addEventListener('change', function() {
    const file = this.files[0];
    if (file) {
        const maxSize = 30 * 1024 * 1024; // 30MB in bytes
        if (file.size > maxSize) {
            alert('File size must be less than 10MB');
            this.value = '';
        }
    }
});
</script>

@include('admin.footer')

