@include('admin.header')

<div class='container-fluid'>
    <div class='row'>
        <div class='col-12'>
            <div class='card shadow-lg border-0'>
                <div class='card-header bg-gradient-primary text-white'>
                    <div class='d-flex justify-content-between align-items-center'>
                        <h3 class='mb-0'>
                            <i class='fas fa-clipboard-check me-2'></i>
                            Order Confirmation Details - {{ $orderConfirmation->order_number ?? 'N/A' }}
                        </h3>
                        <div class='btn-group'>
                            <a href='{{ route('admin.order-confirmations.edit', $orderConfirmation->id) }}' class='btn btn-light btn-sm'>
                                <i class='fas fa-edit me-1'></i>Edit
                            </a>
                            <button class='btn btn-danger btn-sm'>
                                <i class='fas fa-trash me-1'></i>Delete
                            </button>
                        </div>
                    </div>
                </div>

                <div class='card-body p-0'>
                    <!-- Order Confirmation Details Section -->
                    <div class='p-4 bg-light border-bottom'>
                        <h5 class='text-primary mb-3'>
                            <i class='fas fa-info-circle me-2'></i>
                            Order Details
                        </h5>
                        <div class='row g-3'>
                            <div class='col-md-4'>
                                <div class='info-item'>
                                    <label class='text-muted small'>Order Number</label>
                                    <div class='fw-bold'>{{ $orderConfirmation->order_number ?? 'N/A' }}</div>
                                </div>
                            </div>
                            <div class='col-md-4'>
                                <div class='info-item'>
                                    <label class='text-muted small'>Customer PO Number</label>
                                    <div class='fw-bold'>{{ $orderConfirmation->customer_po_number ?? 'N/A' }}</div>
                                </div>
                            </div>
                            <div class='col-md-4'>
                                <div class='info-item'>
                                    <label class='text-muted small'>Confirmed Quantity</label>
                                    <div class='fw-bold'>{{ number_format($orderConfirmation->confirmed_quantity ?? 0) }}</div>
                                </div>
                            </div>
                            <div class='col-md-4'>
                                <div class='info-item'>
                                    <label class='text-muted small'>Confirmed Price</label>
                                    <div class='fw-bold'>${{ number_format($orderConfirmation->confirmed_price ?? 0, 2) }}</div>
                                </div>
                            </div>
                            <div class='col-md-4'>
                                <div class='info-item'>
                                    <label class='text-muted small'>Delivery Date</label>
                                    <div class='fw-bold'>@php
    use Carbon\Carbon;
@endphp

<div class='fw-bold'>
    {{ $orderConfirmation->delivery_date 
        ? Carbon::parse($orderConfirmation->delivery_date)->format('M d, Y') 
        : 'N/A' }}
</div>
</div>
                                </div>
                            </div>
                            <div class='col-md-4'>
                                <div class='info-item'>
                                    <label class='text-muted small'>Payment Terms</label>
                                    <div class='fw-bold'>{{ $orderConfirmation->payment_terms ?? 'N/A' }}</div>
                                </div>
                            </div>
                            <div class='col-md-12'>
                                <div class='info-item'>
                                    <label class='text-muted small'>Special Instructions</label>
                                    <div class='fw-bold'>{{ $orderConfirmation->special_instructions ?? 'N/A' }}</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Quotation Details Section -->
                    <div class='p-4 border-bottom'>
                        <h5 class='text-primary mb-3'>
                            <i class='fas fa-calculator me-2'></i>
                            Related Quotation Details
                        </h5>
                        @if($orderConfirmation->quotation)
                            <div class='row g-3'>
                          <!--       <div class='col-md-4'>
                                    <div class='info-item'>
                                        <label class='text-muted small'>Quotation Number</label>
                                        <div class='fw-bold'>{{ $orderConfirmation->quotation->quotation_number ?? 'N/A' }}</div>
                                    </div>
                                </div> -->
                                <div class='col-md-6'>
                                    <div class='info-item'>
                                        <label class='text-muted small'>Quoted Price</label>
                                        <div class='fw-bold'>${{ number_format($orderConfirmation->quotation->quoted_price ?? 0, 2) }}</div>
                                    </div>
                                </div>
                                <div class='col-md-6'>
                                    <div class='info-item'>
                                        <label class='text-muted small'>Quotation Status</label>
                                        <div class='fw-bold'>
                                            <span class='badge bg-{{ $orderConfirmation->quotation->status_badge_color ?? 'secondary' }}' >
                                                {{ $orderConfirmation->quotation->status_label ?? 'N/A' }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class='alert alert-warning'>No related quotation found.</div>
                        @endif
                    </div>

                    <!-- Inquiry Details Section -->
                    <div class='p-4 bg-light border-bottom'>
                        <h5 class='text-primary mb-3'>
                            <i class='fas fa-search me-2'></i>
                            Related Inquiry Details
                        </h5>
                        @if($orderConfirmation->quotation?->inquiry)
                            <div class='row g-3'>
                                <div class='col-md-4'>
                                    <div class='info-item'>
                                        <label class='text-muted small'>Customer</label>
                                        <div class='fw-bold'>{{ $orderConfirmation->quotation->inquiry->buyer?->company_name ?? 'N/A' }}</div>
                                    </div>
                                </div>
                                <div class='col-md-4'>
                                    <div class='info-item'>
                                        <label class='text-muted small'>Item Description</label>
                                        <div class='fw-bold'>{{ $orderConfirmation->quotation->inquiry->itemDescription?->name ?? 'N/A' }}</div>
                                    </div>
                                </div>
                                <div class='col-md-4'>
                                    <div class='info-item'>
                                        <label class='text-muted small'>Brand</label>
                                        <div class='fw-bold'>{{ $orderConfirmation->quotation->inquiry->brand?->name ?? 'N/A' }}</div>
                                    </div>
                                </div>
                                <div class='col-md-4'>
                                    <div class='info-item'>
                                        <label class='text-muted small'>Order Quantity</label>
                                        <div class='fw-bold'>{{ number_format($orderConfirmation->quotation->inquiry->order_quantity ?? 0) }}</div>
                                    </div>
                                </div>
                                <div class='col-md-4'>
                                    <div class='info-item'>
                                        <label class='text-muted small'>Target Price</label>
                                        <div class='fw-bold'>${{ number_format($orderConfirmation->quotation->inquiry->target_price ?? 0, 2) }}</div>
                                    </div>
                                </div>
                                <div class='col-md-4'>
                                    <div class='info-item'>
                                        <label class='text-muted small'>Shipment Date</label>
                                        <div class='fw-bold'>
    {{ optional(optional($orderConfirmation->quotation)->inquiry)->shipment_date 
        ? \Carbon\Carbon::parse(optional($orderConfirmation->quotation->inquiry)->shipment_date)->format('M d, Y') 
        : 'N/A' }}


</div>
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class='alert alert-warning'>No related inquiry found.</div>
                        @endif
                    </div>

                    <!-- Documents Section -->
                    <div class='p-4 border-bottom'>
                        <h5 class='text-primary mb-3'>
                            <i class='fas fa-file-alt me-2'></i>
                            Documents
                        </h5>
                 @if($orderConfirmation->documents->count() > 0)
    <ul class='list-group'>
        @foreach($orderConfirmation->documents as $document)
            <li class='list-group-item d-flex justify-content-between align-items-center'>
                <div>
                    <i class='fas fa-file me-2'></i>
                    {{ $document->file_name }} ({{ $document->document_type }})
                    <small class='text-muted ms-2'>
                        Uploaded by {{ $document->uploader->name ?? 'N/A' }} on {{ $document->created_at->format('M d, Y') }}
                    </small>
                </div>
                <div>
                    <a href='{{ route('admin.order-documents.download', $document->id) }}' 
                       class='btn btn-sm btn-outline-primary me-2'>
                        <i class='fas fa-download'></i> Download
                    </a>

                    <form action="{{ route('admin.order-documents.destroy', $document->id) }}" 
                          method="POST" style="display:inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-outline-danger"
                                onclick="return confirm('Are you sure you want to delete this document?')">
                            <i class='fas fa-trash'></i> Delete
                        </button>
                    </form>
                </div>
            </li>
        @endforeach
    </ul>

                        @else
                            <div class='alert alert-info'>No documents uploaded yet.</div>
                        @endif
                        <div class='mt-3 text-end'>
                            <a href='{{ route('admin.order-documents.create', ['order_confirmation_id' => $orderConfirmation->id]) }}' class='btn btn-primary'>
                                <i class='fas fa-upload me-1'></i>Upload Document
                            </a>
                        </div>
                    </div>

                    <!-- Status History Section -->
                    <div class='p-4'>
                        <h5 class='text-primary mb-3'>
                            <i class='fas fa-history me-2'></i>
                            Status History
                        </h5>
                        @if($orderConfirmation->statusHistory->count() > 0)
                            <ul class='list-group'>
                                @foreach($orderConfirmation->statusHistory as $history)
                                    <li class='list-group-item'>
                                        <strong>{{ ucfirst($history->old_status) }}</strong> to <strong>{{ ucfirst($history->new_status) }}</strong>
                                        <small class='text-muted ms-2'>
                                            by {{ $history->changedBy->name ?? 'N/A' }} on {{ $history->created_at->format('M d, Y H:i') }}
                                        </small>
                                        @if($history->notes)
                                            <p class='mb-0 text-muted small'>Notes: {{ $history->notes }}</p>
                                        @endif
                                    </li>
                                @endforeach
                            </ul>
                        @else
                            <div class='alert alert-info'>No status history available.</div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.footer')
