<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Proforma Invoice</title>
</head>
<body>
    {{-- Logo (image1) --}}


    {{-- Watermark (image2) - small faded centered --}}
    @if(!empty($seller->image2))
        <img src="{{ public_path($seller->image2) }}" style="position: fixed; top: 35%!important; left: 40%!important; width: 400px!important; height: 400px!important; opacity: 0.10!important; transform: translate(-50%, -50%)!important; z-index: 0!important;" alt="watermark">
    @endif

    {{-- Footer image (image3) --}}
    @if(!empty($seller->image3))
        <img src="{{ public_path($seller->image3) }}" style="position: fixed; bottom: 0; left: 0; width: 100%; height: auto; z-index: 1;" alt="footer">
    @endif
    @if(!empty($seller->image1))
        <img src="{{ public_path($seller->image1) }}" style="position: fixed; margin-top: -145px; left: 1px; width: 250px; height: 270px; z-index: 5;" alt="logo">
    @endif
      <h1 style="float: right; font-size: 22px; letter-spacing: 0.5px; font-weight: 900; margin-top:-20px;">PROFORMA INVOICE</h1>
    <div style="text-align: center; margin-top: 25px; z-index: 5; position: relative;">
      
        <div style="margin-top: 19px; font-size: 11px;">
            <span  style="font-weight:700;">PI Number: {{ $piNumber }}</span> &nbsp; | &nbsp;
            <span style="font-weight:700;">Order #: {{ $order->order_number }}</span> &nbsp; | &nbsp;
            <span style="font-weight:700;">Date: {{ $order->created_at->format('d-m-Y') }}</span>
        </div>
    </div>

    <!-- SELLER / BUYER / SHIP TO boxed area -->
    <table style="width: 100%; border-collapse: collapse; margin-top: 15px; z-index: 5; position: relative; page-break-inside: avoid;">
        <tr>
            <td style="vertical-align: top; padding: 8px 10px;  width: 33.333%;">
                <span style="display: block; font-weight: 700; font-size: 12px; margin-bottom: 6px; padding-bottom: 4px; ">SELLER</span>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Company:</strong> {{ $seller->company_name ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Address:</strong> {{ ($seller->plot ?? '') }} {{ ($seller->road ?? '') }} {{ ($seller->avenue ?? '') }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Telephone:</strong> {{ $seller->telephone ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>VAT:</strong> {{ $seller->vat ?? 'N/A' }}</p>

                <div style="margin-top: 8px; font-weight: 700; border-bottom: 1px dashed #000; padding-bottom: 4px; font-size: 11px;">BENEFICIARY BANK DETAILS</div>
                <p style="margin: 4px 0; font-size: 10px;"><strong>A/C NAME:</strong> {{ $order->quotation->inquiry->buyer->bank->account_name ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>A/C NO:</strong> {{ $order->quotation->inquiry->buyer->bank->account_no ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>IBAN:</strong> {{ $order->quotation->inquiry->buyer->bank->iban ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>SWIFT:</strong> {{ $order->quotation->inquiry->buyer->bank->swift ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Bank Address:</strong> {{ $order->quotation->inquiry->buyer->bank->bank_address ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Correspondent Bank:</strong> {{ $order->quotation->inquiry->buyer->bank->correspondent_bank ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Corres. SWIFT:</strong> {{ $order->quotation->inquiry->buyer->bank->correspondent_swift ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Corres. A/C NO:</strong> {{ $order->quotation->inquiry->buyer->bank->correspondent_account ?? 'N/A' }}</p>
            </td>

            <td style="vertical-align: top; padding: 8px 10px;  width: 33.333%;">
                <span style="display: block; font-weight: 700; font-size: 12px; margin-bottom: 6px; padding-bottom: 4px; ">BUYER</span>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Company:</strong> {{ $order->quotation->inquiry->buyer->company_name ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Address:</strong> {{ $order->quotation->inquiry->buyer->address ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Phone:</strong> {{ $order->quotation->inquiry->buyer->phone ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Fax:</strong> {{ $order->quotation->inquiry->buyer->fax ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>VAT NUMBER:</strong> {{ $order->quotation->inquiry->buyer->vat ?? 'N/A' }}</p>
            </td>

            <td style="vertical-align: top; padding: 8px 10px;  width: 33.333%;">
                <span style="display: block; font-weight: 700; font-size: 12px; margin-bottom: 6px; padding-bottom: 4px; ">SHIP TO</span>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Company:</strong> {{ $order->quotation->inquiry->buyer->company_name ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Address:</strong> {{ $order->quotation->inquiry->buyer->address ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Phone:</strong> {{ $order->quotation->inquiry->buyer->phone ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>Fax:</strong> {{ $order->quotation->inquiry->buyer->fax ?? 'N/A' }}</p>
                <p style="margin: 4px 0; font-size: 10px;"><strong>VAT NUMBER:</strong> {{ $order->quotation->inquiry->buyer->vat ?? 'N/A' }}</p>
            </td>
        </tr>
    </table>

    <!-- Items table (mimic PDF structure) -->
    <table style="width: 100%; border-collapse: collapse; margin-top: 14px; z-index: 5; position: relative; page-break-inside: avoid;">
        <thead>
            <tr>
                <th style="width:6%; border: 1px solid #000; padding: 6px 8px; font-size: 11px; font-weight: 700; text-align: left; background: #1e1e1e; color: white;">SL NO.</th>
                <th style="width:12%; border: 1px solid #000; padding: 6px 8px; font-size: 11px; font-weight: 700; text-align: left; background: #1e1e1e; color: white;">PO NO.</th>
                <th style="width:12%; border: 1px solid #000; padding: 6px 8px; font-size: 11px; font-weight: 700; text-align: left; background: #1e1e1e; color: white;">STYLE/ITEM NO.</th>
                <th style="border: 1px solid #000; padding: 6px 8px; font-size: 11px; font-weight: 700; text-align: left; background: #1e1e1e; color: white;">ITEM DESCRIPTION</th>
                <th style="width:16%; border: 1px solid #000; padding: 6px 8px; font-size: 11px; font-weight: 700; text-align: left; background: #1e1e1e; color: white;">FABRICS / COMPOSITION</th>
                <th style="width:9%; border: 1px solid #000; padding: 6px 8px; font-size: 11px; font-weight: 700; text-align: left;background: #1e1e1e; color: white;">UNIT PRICE</th>
                <th style="width:8%; border: 1px solid #000; padding: 6px 8px; font-size: 11px; font-weight: 700; text-align: center;background: #1e1e1e; color: white;">QUANTITY</th>
                <th style="width:12%; border: 1px solid #000; padding: 6px 8px; font-size: 11px; font-weight: 700; text-align: right; background: #1e1e1e; color: white;">VALUE</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td style="border: 1px solid #000; padding: 6px 8px; font-size: 11px; text-align: center;">02</td>
                <td style="border: 1px solid #000; padding: 6px 8px; font-size: 11px; text-align: center;">{{ $order->quotation->inquiry->purchase_order_no ?? 'N/A' }}</td>
                <td style="border: 1px solid #000; padding: 6px 8px; font-size: 11px; text-align: center;">{{ $order->quotation->inquiry->style_number ?? 'N/A' }}</td>
                <td style="border: 1px solid #000; padding: 6px 8px; font-size: 11px;">{{ $order->quotation->inquiry->itemDescription->name ?? 'N/A' }}</td>
                <td style="border: 1px solid #000; padding: 6px 8px; font-size: 11px;">{{ $order->quotation->inquiry->fabricComposition->name ?? 'N/A' }}</td>
                <td style="border: 1px solid #000; padding: 6px 8px; font-size: 11px; text-align: right;">{{ number_format($order->confirmed_price, 2) }}</td>
                <td style="border: 1px solid #000; padding: 6px 8px; font-size: 11px; text-align: center;">{{ number_format($order->confirmed_quantity) }}</td>
                <td style="border: 1px solid #000; padding: 6px 8px; font-size: 11px; text-align: right;">{{ isset($order->confirmed_price) ? '$'.number_format($order->confirmed_price,2) : 'N/A' }}</td>
            </tr>

            <!-- TOTAL row -->
            <tr>
                <td style="border: 1px solid #000; padding: 6px 8px; font-size: 11px; font-weight: 700; text-align: right;" colspan="6">TOTAL</td>
                <td style="border: 1px solid #000; padding: 6px 8px; font-size: 11px; font-weight: 700; text-align: center;">{{ $order->quotation->inquiry->quantity ?? ($order->quantity ?? 'N/A') }}</td>
                <td style="border: 1px solid #000; padding: 6px 8px; font-size: 11px; font-weight: 700; text-align: right;">{{ isset($order->confirmed_price) ? '$'.number_format($order->confirmed_price,2) : 'N/A' }}</td>
            </tr>
        </tbody>
    </table>

    <!-- General Terms & Non-performance, laid out similar to the PDF -->
    <div style="margin-top: 14px; z-index: 5; position: relative; page-break-inside: avoid;">
        <div style="font-weight: 700; margin-bottom: 4px; font-size: 11px;">GENERAL TERMS &amp; CONDITIONS</div>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>MODE OF PAYMENT :</strong> {{ $order->payment_mode ?? 'BY TT' }}</p>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>CURRENCY :</strong> {{ $order->currency ?? 'USD' }}</p>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>PAYMENT SCHEDULE :</strong> {{ $order->payment_schedule ?? '20% ADVANCE, 80% AFTER SHIPMENT' }}</p>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>BANK CHARGE :</strong> {{ $order->bank_charge ?? 'EACH PARTY SHALL BEAR ITS RESPECTIVE BANK CHARGES' }}</p>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>TOLERANCE :</strong> {{ $order->tolerance ?? '5% TOLERANCE IS ALLOWED FOR QUANTITY AND VALUE' }}</p>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>INCOTERMS :</strong> {{ $order->incoterms ?? 'FOB, ANY PORT OF BANGLADESH' }}</p>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>DELIVERY DATE :</strong> {{ $order->delivery_date ?? '30-09-2025' }}</p>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>EXPIRY DATE :</strong> {{ $order->expiry_date ?? '30-09-2025' }}</p>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>PORT OF LOADING :</strong> {{ $order->port_of_loading ?? 'CHATTOGRAM, BANGLADESH' }}</p>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>PORT OF DISCHARGE :</strong> {{ $order->port_of_discharge ?? 'ASHDOD/ISRAEL' }}</p>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>COUNTRY OF ORIGIN :</strong> {{ $order->country_of_origin ?? 'BANGLADESH' }}</p>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>COUNTRY OF DESTINATION :</strong> {{ $order->country_of_destination ?? 'ASHDOD/ISRAEL' }}</p>

        <div style="margin-top:8px;"></div>

        <div style="font-weight: 700; margin-bottom: 4px; font-size: 11px;">NON-PERFORMANCE</div>
        <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;">{{ $order->non_performance_text ?? 'TEXASIA SHALL NOT BE LIABLE FOR NON-PERFORMANCE DUE TO FORCE MAJEURE EVENTS, INCLUDING BUT NOT LIMITED TO NATURAL DISASTERS, WAR, GOVERNMENT RESTRICTIONS, PANDEMICS, OR SUPPLY CHAIN INTERRUPTIONS.' }}</p>
    </div>

    <!-- Additional terms pulled from $terms (keeps your loop unchanged) -->
    <div style="margin-top: 14px; z-index: 5; position: relative; page-break-inside: avoid;">
        @foreach($terms as $term)
            <p style="margin: 4px 0; font-size: 10.5px; line-height: 1.2;"><strong>{{ $term->title ?? 'N/A' }} :</strong> {{ $term->content ?? 'N/A' }}</p>
        @endforeach
    </div>

    <!-- Signature area -->
    <table style="width: 100%; margin-top: 78px; border-collapse: collapse; z-index: 5; position: relative; page-break-inside: avoid;">
        <tr>
            <td style="width: 50%; vertical-align: top; padding: 10px; ">
                <div style="border-top: 1px dashed; #000; padding-top: 10px; width: 40%; font-size: 10px;">SELLER SIGN &amp; SEAL</div>
            </td>
            <td></td>
            <td style="width: 50%; vertical-align: top; padding: 10px;">
                <div style="font-size: 10px; border-top: 1px dashed; #000; padding-top: 8px; width: 90%;">BUYER SIGN &amp; SEAL</div>
            </td>
    
        </tr>
       
    </table>

    {{-- Stamp (image4) --}}
    @if(!empty($seller->image4))
        <img src="{{ public_path($seller->image4) }}" style="position: fixed; bottom: 170px; left: 5px; width: 120px; z-index: 6; opacity: 0.95" alt="stamp">
    @endif

</body>
</html>