@include('admin.header')

<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-6">
            <h1><i class="fas fa-clipboard-check me-2"></i>Order Confirmations</h1>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('admin.quotations.index') }}?status=won" class="btn btn-primary">
                <i class="fas fa-plus me-1"></i>Create New Order (From Won Quotations)
            </a>
        </div>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show">
            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Status Dashboard Cards -->
    <div class="row mb-4">
        <div class="col-md-2">
            <div class="card bg-secondary text-white">
                <div class="card-body text-center">
                    <h4>{{ $statusCounts['pending'] }}</h4>
                    <small>Pending</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-primary text-white">
                <div class="card-body text-center">
                    <h4>{{ $statusCounts['confirmed'] }}</h4>
                    <small>Confirmed</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-warning text-white">
                <div class="card-body text-center">
                    <h4>{{ $statusCounts['in_production'] }}</h4>
                    <small>In Production</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-info text-white">
                <div class="card-body text-center">
                    <h4>{{ $statusCounts['shipped'] }}</h4>
                    <small>Shipped</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-success text-white">
                <div class="card-body text-center">
                    <h4>{{ $statusCounts['delivered'] }}</h4>
                    <small>Delivered</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-danger text-white">
                <div class="card-body text-center">
                    <h4>{{ $statusCounts['overdue'] }}</h4>
                    <small>Overdue</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('admin.order-confirmations.index') }}" class="row g-3">
                <div class="col-md-3">
                    <label for="status" class="form-label">Status</label>
                    <select name="status" id="status" class="form-select">
                        <option value="">All Statuses</option>
                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="confirmed" {{ request('status') == 'confirmed' ? 'selected' : '' }}>Confirmed</option>
                        <option value="in_production" {{ request('status') == 'in_production' ? 'selected' : '' }}>In Production</option>
                        <option value="shipped" {{ request('status') == 'shipped' ? 'selected' : '' }}>Shipped</option>
                        <option value="delivered" {{ request('status') == 'delivered' ? 'selected' : '' }}>Delivered</option>
                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="search" class="form-label">Search</label>
                    <input type="text" name="search" id="search" class="form-control" 
                           placeholder="Order number, PO number..." value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <label for="delivery_from" class="form-label">Delivery From</label>
                    <input type="date" name="delivery_from" id="delivery_from" class="form-control" 
                           value="{{ request('delivery_from') }}">
                </div>
                <div class="col-md-2">
                    <label for="delivery_to" class="form-label">Delivery To</label>
                    <input type="date" name="delivery_to" id="delivery_to" class="form-control" 
                           value="{{ request('delivery_to') }}">
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-search me-1"></i>Filter
                    </button>
                    <a href="{{ route('admin.order-confirmations.index') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-times me-1"></i>Clear
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Orders Table -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead class="table-dark">
                        <tr>
                            <th>Order Number</th>
                            <th>Quotation</th>
                            <th>Customer</th>
                            <th>Customer Email</th>

                            <th>Item</th>
                            <th>Quantity</th>
                            <th>Price</th>
                            <th>Total Value</th>
                            <th>Delivery Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($orderConfirmations as $order)
                            <tr class="{{ $order->is_overdue ? 'table-warning' : '' }}">
                                <td>
                                    <strong>{{ $order->order_number }}</strong>
                                    @if($order->customer_po_number)
                                        <br><small class="text-muted">PO: {{ $order->customer_po_number }}</small>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('admin.quotations.show', $order->quotation_id) }}" class="text-decoration-none">
                                        {{ $order->quotation->quotation_number }}
                                    </a>
                                </td>
                                <td>{{ $order->quotation->inquiry->buyer->company_name ?? 'N/A' }}</td>

                                <td>{{ $order->quotation->inquiry->buyer->email ?? 'N/A' }}</td>
                                <td>{{ $order->quotation->inquiry->itemDescription->name ?? 'N/A' }}</td>
                                <td>{{ number_format($order->confirmed_quantity) }}</td>
                                <td>${{ number_format($order->confirmed_price, 2) }}</td>
                                <td><strong>${{ number_format($order->total_value, 2) }}</strong></td>
                                <td>
                                    {{ $order->formatted_delivery_date }}
                                    @if($order->is_overdue)
                                        <br><small class="text-danger"><i class="fas fa-exclamation-triangle"></i> Overdue</small>
                                    @elseif($order->days_until_delivery !== null && $order->days_until_delivery <= 7 && $order->days_until_delivery >= 0)
                                        <br><small class="text-warning"><i class="fas fa-clock"></i> {{ $order->days_until_delivery }} days</small>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-{{ $order->status_badge_color }}">
                                        {{ ucfirst(str_replace('_', ' ', $order->status)) }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('admin.order-confirmations.show', $order) }}" 
                                           class="btn btn-info btn-sm" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.order-confirmations.edit', $order) }}" 
                                           class="btn btn-warning btn-sm" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
       <a href="{{ route('admin.order-confirmations.pdf', $order->id) }}" target="_blank" 
   class="btn btn-sm btn-warning">
   Generate PI PDF
</a>
<a href="{{ route('admin.order-confirmations.sc', $order->id) }}" target="_blank" class="btn btn-sm btn-secondary">Generate SC</a>
   <form action="{{ route('admin.order-confirmations.upload-po', $order->id) }}" 
          method="POST" enctype="multipart/form-data" style="display:inline-block;">
        @csrf
        <input type="file" name="pi_file" accept="application/pdf" required 
               style="width:180px; margin-bottom:5px;">
        <button type="submit" class="btn btn-sm btn-primary">Upload Buyer PO</button>
    </form>

      <!-- View Buyer PO (if uploaded) -->
    @if($order->pi_file)
        <a href="{{ asset($order->pi_file) }}" target="_blank" 
           class="btn btn-sm btn-secondary">View Buyer PO</a>
    @endif


<form action="{{ route('admin.order-confirmations.update-status', $order->id) }}" method="POST" class="d-inline">
    @csrf
    <div class="dropdown">
        <button class="btn btn-outline-primary btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown">
            <i class="fas fa-sync-alt me-1"></i> Update Status
        </button>
        <ul class="dropdown-menu">
            <li>
                <button type="submit" name="status" value="pending" class="dropdown-item">Pending</button>
            </li>
            <li>
                <button type="submit" name="status" value="confirmed" class="dropdown-item">Confirmed</button>
            </li>
            <li>
                <button type="submit" name="status" value="in_production" class="dropdown-item">In Production</button>
            </li>
            <li>
                <button type="submit" name="status" value="shipped" class="dropdown-item">Shipped</button>
            </li>
            <li>
                <button type="submit" name="status" value="delivered" class="dropdown-item">Delivered</button>
            </li>
            <li>
                <button type="submit" name="status" value="cancelled" class="dropdown-item">Cancelled</button>
            </li>
        </ul>
    </div>
</form>

                                        @if(in_array($order->status, ['pending', 'cancelled']))
                                            <form action="{{ route('admin.order-confirmations.destroy', $order) }}" 
                                                  method="POST" style="display:inline-block;"
                                                  onsubmit="return confirm('Are you sure you want to delete this order?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="10" class="text-center py-4">
                                    <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                    <p class="text-muted">No order confirmations found.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            @if ($orderConfirmations->hasPages())
                <div class="d-flex justify-content-center mt-3">
                    {{ $orderConfirmations->links() }}
                </div>
            @endif
        </div>
    </div>
</div>




<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

@include('admin.footer')

