@include('admin.header')

<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-8">
            <h1><i class="fas fa-plus-circle me-2"></i>Create Order Confirmation</h1>
            <p class="text-muted">Convert quotation #{{ $quotation->quotation_number }} to order confirmation</p>
        </div>
        <div class="col-md-4 text-right">
            <a href="{{ route('admin.quotations.show', $quotation) }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-1"></i>Back to Quotation
            </a>
        </div>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger">
            <h6><i class="fas fa-exclamation-circle me-2"></i>Please fix the following errors:</h6>
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.order-confirmations.store') }}" method="POST">
        @csrf
        <input type="hidden" name="quotation_id" value="{{ $quotation->id }}">

        <!-- Quotation Details (Read Only) -->
        <div class="card mb-4">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Quotation Details (Read Only)</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="info-item mb-3">
                            <label class="text-muted small">Customer</label>
                            <div class="fw-bold">{{ $quotation->inquiry->buyer->company_name ?? 'N/A' }}</div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-item mb-3">
                            <label class="text-muted small">Item Description</label>
                            <div class="fw-bold">{{ $quotation->inquiry->itemDescription->name ?? 'N/A' }}</div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-item mb-3">
                            <label class="text-muted small">Brand</label>
                            <div class="fw-bold">{{ $quotation->inquiry->brand->name ?? 'N/A' }}</div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-item mb-3">
                            <label class="text-muted small">Inquiry Quantity</label>
                            <div class="fw-bold">{{ number_format($quotation->inquiry->order_quantity) }}</div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-item mb-3">
                            <label class="text-muted small">Quoted Price</label>
                            <div class="fw-bold text-success">${{ number_format($quotation->quoted_price, 2) }}</div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="info-item mb-3">
                            <label class="text-muted small">Total Cost</label>
                            <div class="fw-bold">${{ number_format($quotation->calculated_total_cost, 2) }}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Order Confirmation Details -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="fas fa-clipboard-check me-2"></i>Order Confirmation Details</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="customer_po_number" class="form-label">Customer PO Number</label>
                            <input type="text" name="customer_po_number" id="customer_po_number" 
                                   class="form-control" value="{{ old('customer_po_number') }}"
                                   placeholder="Enter customer purchase order number">
                            <small class="form-text text-muted">Optional: Customer's purchase order reference</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="delivery_date" class="form-label">Delivery Date</label>
                            <input type="date" name="delivery_date" id="delivery_date" 
                                   class="form-control" value="{{ old('delivery_date') }}"
                                   min="{{ date('Y-m-d', strtotime('+1 day')) }}">
                            <small class="form-text text-muted">Expected delivery date</small>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="confirmed_quantity" class="form-label">Confirmed Quantity <span class="text-danger">*</span></label>
                            <input type="number" name="confirmed_quantity" id="confirmed_quantity" 
                                   class="form-control" value="{{ old('confirmed_quantity', $quotation->inquiry->order_quantity) }}"
                                   min="1" required>
                            <small class="form-text text-muted">Final confirmed order quantity</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="confirmed_price" class="form-label">Confirmed Price (per unit) <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text">$</span>
                                <input type="number" name="confirmed_price" id="confirmed_price" 
                                       class="form-control" value="{{ old('confirmed_price', $quotation->quoted_price) }}"
                                       min="0" step="0.01" required>
                            </div>
                            <small class="form-text text-muted">Final confirmed price per unit</small>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group mb-3">
                            <label for="payment_terms" class="form-label">Payment Terms</label>
                            <textarea name="payment_terms" id="payment_terms" class="form-control" rows="3"
                                      placeholder="Enter payment terms and conditions">{{ old('payment_terms') }}</textarea>
                            <small class="form-text text-muted">Payment terms, conditions, and schedule</small>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group mb-3">
                            <label for="special_instructions" class="form-label">Special Instructions</label>
                            <textarea name="special_instructions" id="special_instructions" class="form-control" rows="3"
                                      placeholder="Enter any special instructions or requirements">{{ old('special_instructions') }}</textarea>
                            <small class="form-text text-muted">Any special requirements, packaging instructions, etc.</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Order Summary -->
        <div class="card mb-4">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="fas fa-calculator me-2"></i>Order Summary</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="summary-item text-center p-3 border rounded">
                            <h6 class="text-muted">Quantity</h6>
                            <h4 id="summary_quantity">{{ number_format($quotation->inquiry->order_quantity) }}</h4>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="summary-item text-center p-3 border rounded">
                            <h6 class="text-muted">Unit Price</h6>
                            <h4 id="summary_unit_price">${{ number_format($quotation->quoted_price, 2) }}</h4>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="summary-item text-center p-3 border rounded">
                            <h6 class="text-muted">Total Value</h6>
                            <h4 id="summary_total_value" class="text-success">
                                ${{ number_format($quotation->inquiry->order_quantity * $quotation->quoted_price, 2) }}
                            </h4>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="summary-item text-center p-3 border rounded">
                            <h6 class="text-muted">Profit Margin</h6>
                            <h4 class="text-info">{{ number_format($quotation->profit_margin, 1) }}%</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <a href="{{ route('admin.quotations.show', $quotation) }}" class="btn btn-outline-secondary">
                        <i class="fas fa-times me-1"></i>Cancel
                    </a>
                    <button type="submit" class="btn btn-success btn-lg">
                        <i class="fas fa-check me-1"></i>Create Order Confirmation
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
// Update summary when quantity or price changes
function updateSummary() {
    const quantity = parseInt(document.getElementById('confirmed_quantity').value) || 0;
    const price = parseFloat(document.getElementById('confirmed_price').value) || 0;
    const totalValue = quantity * price;
    
    document.getElementById('summary_quantity').textContent = quantity.toLocaleString();
    document.getElementById('summary_unit_price').textContent = '$' + price.toFixed(2);
    document.getElementById('summary_total_value').textContent = '$' + totalValue.toLocaleString('en-US', {minimumFractionDigits: 2});
}

document.getElementById('confirmed_quantity').addEventListener('input', updateSummary);
document.getElementById('confirmed_price').addEventListener('input', updateSummary);

// Set minimum delivery date to tomorrow
document.addEventListener('DOMContentLoaded', function() {
    const tomorrow = new Date();
    tomorrow.setDate(tomorrow.getDate() + 1);
    const minDate = tomorrow.toISOString().split('T')[0];
    document.getElementById('delivery_date').setAttribute('min', minDate);
});
</script>

@include('admin.footer')

