@include('admin.header') 
<style >
    h5{
        color: white;
    }
</style>
<div class="container bg-white p-3 mt-4 shadow-md" >
    <div class="row mb-4">
        <div class="col-md-6">
            <h1>Inquiry Details #{{ $inquiry->id }}</h1>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('admin.inquiries.edit', $inquiry->id) }}" class="btn btn-primary"><i class="fas fa-edit"></i> Update</a>
            <a href="{{ route('admin.inquiries.index') }}" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Back to List</a>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Customer Information</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Customer Name:</strong> {{ $inquiry->buyer->company_name }}</p>
                    <p><strong>Purchase Order (PO) No:</strong> {{ $inquiry->purchase_order_no }}</p>
                </div>
                <div class="col-md-6">
                    <p><strong>Style Number:</strong> {{ $inquiry->style_number }}</p>
                    <p><strong>Item No:</strong> {{ $inquiry->item_no }}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Product Details</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Brand:</strong> {{ $inquiry->brand->name }}</p>
                    <p><strong>Item Description:</strong> {{ $inquiry->itemDescription->name }}</p>
                    <p><strong>Size Range:</strong> {{ $inquiry->sizeRange->name }}</p>
                    <p><strong>Color:</strong> {{ $inquiry->color->name }}</p>
                </div>
                <div class="col-md-6">
                    <p><strong>Order Quantity:</strong> {{ $inquiry->order_quantity }}</p>
                    <p><strong>Target Price:</strong> {{ $inquiry->target_price ? '$'.number_format($inquiry->target_price, 2) : 'N/A' }}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Fabric Details</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Fabric Composition:</strong> {{ $inquiry->fabricComposition->name }}</p>
                    <p><strong>Fabric Type:</strong> {{ $inquiry->fabricType->name }}</p>
                </div>
                <div class="col-md-6">
                    <p><strong>Yarn Count:</strong> {{ $inquiry->yarnCount->name }}</p>
                    <p><strong>Fabric Weight/GSM:</strong> {{ $inquiry->fabricWeight->name }}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Shipping Details</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Shipment Date:</strong> {{ $inquiry->shipment_date->format('Y-m-d') }}</p>
                    <p><strong>Port of Loading:</strong> {{ $inquiry->portOfLanding->name }}</p>
                    <p><strong>Country of Origin:</strong> {{ $inquiry->countryOfOrigin->name }}</p>
                    <p><strong>Port of Discharge:</strong> {{ $inquiry->portOfDischarge->name }}</p>
                </div>
                <div class="col-md-6">
                    <p><strong>Final Destination:</strong> {{ $inquiry->finalDestination->name }}</p>
                    <p><strong>Delivery Term:</strong> {{ $inquiry->deliveryTerm->name }}</p>
                    <p><strong>Shipment Mode:</strong> {{ $inquiry->shipmentMode->name }}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Additional Information</h5>
        </div>
        <div class="card-body">
         <label>Item Image</label>
@if($inquiry->images)
    <img src="{{ asset('inquiries/'.$inquiry->images) }}" style="max-width: 150px;" alt="">
@endif

            <p><strong>Created At:</strong> {{ $inquiry->created_at->format('Y-m-d H:i:s') }}</p>
            <p><strong>Last Updated:</strong> {{ $inquiry->updated_at->format('Y-m-d H:i:s') }}</p>
        </div>
    </div>
</div>
@include('admin.footer') 
