@include('admin.header') 

<div class="container">
    <div class="row mb-3">
        <div class="col-md-6">
            <h1>Inquiries</h1>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('admin.inquiries.create') }}" class="btn btn-primary"><i class="fas fa-plus"></i> Create New Inquiry</a>
        </div>
    </div>

    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead class="table-dark text-center">
                        <tr>
                            <th>Customer Name</th>
                            <th>PO Number</th>
                            <th>Style Number</th>
                            <th>Item Description</th>
                            <th>Order Quantity</th>
                            <th>Shipment Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($inquiries as $inquiry)
                            <tr>
                                <td>{{ $inquiry->buyer->company_name }}</td>
                                <td>{{ $inquiry->purchase_order_no }}</td>
                                <td>{{ $inquiry->style_number }}</td>
                                <td>{{ $inquiry->itemDescription->name }}</td>
                                <td>{{ $inquiry->order_quantity }}</td>
                                <td>{{ $inquiry->shipment_date->format(' F j, Y') }}</td>
                            
                                <td>
                            
                                   
      <div class="dropdown " >
                                <button class="btn btn-primary btn-sm dropdown-toggle" type="button" id="actionDropdown{{ $inquiry->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                                    Actions
                                </button>
                                <ul class="dropdown-menu p-3" style="z-index: 999!important;" aria-labelledby="actionDropdown{{ $inquiry->id }}">
                                   <i class="fas fa-eye"></i> 

   <a href="{{ route('admin.inquiries.show', $inquiry->id) }}" class="text-dark mb-2">View</a>
                                    </li>
                                    <li>

    <a href="{{ route('admin.inquiries.edit', $inquiry->id) }}" class="text-dark mb-2"><i class="fas fa-edit"></i> Update</a>

    <a href="{{ route('admin.quotations.create', ['inquiry_id' => $inquiry->id]) }}">
  <i class="fas fa-calculator"></i> Quotation Generator
</a>
                        
                                    </li>
                                    <li>
                                   <form action="{{ route('admin.inquiries.destroy', $inquiry->id) }}" method="POST" style="display:inline-block;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="" onclick="return confirm('Are you sure you want to delete this inquiry?')"><i class="fas fa-trash"></i> Remove</button>
                                    </form>
                                    </li>
                                </ul>
                            </div>






                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center">No inquiries found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            {{ $inquiries->links() }} {{-- For pagination --}}
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

@include('admin.footer') 
