@include('admin.header') 
<style >label{
    font-weight: 700;
}
h5{
    color: white;
}
</style>
<div class="container">
    <h1>Create Inquiry</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.inquiries.store') }}" method="POST" class="bg-white p-3 mt-4 shadow-md" enctype="multipart/form-data">>
        @csrf

        {{-- Manual Input Fields --}}
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Customer Information</h5>
            </div>
            <div class="card-body">
                {{-- Customer Name (Manual) --}}
            
                        <div class="form-group mb-3">
                            <label for="brand_id">Buyers</label>
                           <select name="buyer_id" id="buyer_id" class="form-control" required>
                <option value="">Select Buyers</option>
                @foreach($buyer as $buyers)
                    <option value="{{ $buyers->id }}" {{ old('buyer_id') == $buyers->id ? 'selected' : '' }}>{{ $buyers->company_name }}</option>
                @endforeach
            </select>
                        </div>

                {{-- Purchase Order No (Manual) --}}
                <div class="form-group mb-3">
                    <label for="purchase_order_no">Purchase Order (PO) No.</label>
                    <input type="text" name="purchase_order_no" id="purchase_order_no" class="form-control" placeholder="Enter Po" value="{{ old('purchase_order_no') }}" required>
                </div>

                {{-- Style Number (Manual) --}}
                <div class="form-group mb-3">
                    <label for="style_number">Style Number</label>
                    <input type="text" name="style_number" id="style_number" placeholder="Enter Style Number" class="form-control" value="{{ old('style_number') }}" required>
                </div>

                {{-- Item No (Manual) --}}
                <div class="form-group mb-3">
                    <label for="item_no">Item No.</label>
                    <input type="text" name="item_no" id="item_no" class="form-control" placeholder="Enter Item No" value="{{ old('item_no') }}" required>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Product Details</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    {{-- Brand (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="brand_id">Brand</label>
                            <select name="brand_id" id="brand_id" class="form-control" required>
                                <option value="">Select Brand</option>
                                @foreach($brands as $brand)
                                    <option value="{{ $brand->id }}" {{ old('brand_id') == $brand->id ? 'selected' : '' }}>{{ $brand->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Item Description (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="item_description_id">Item Description</label>
                            <select name="item_description_id" id="item_description_id" class="form-control" required>
                                <option value="">Select Item Description</option>
                                @foreach($itemDescriptions as $description)
                                    <option value="{{ $description->id }}" {{ old('item_description_id') == $description->id ? 'selected' : '' }}>{{ $description->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Size Range (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="size_range_id">Size Range</label>
                            <select name="size_range_id" id="size_range_id" class="form-control" required>
                                <option value="">Select Size Range</option>
                                @foreach($sizeRanges as $sizeRange)
                                    <option value="{{ $sizeRange->id }}" {{ old('size_range_id') == $sizeRange->id ? 'selected' : '' }}>{{ $sizeRange->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Color (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="color_id">Color</label>
                            <select name="color_id" id="color_id" class="form-control" required>
                                <option value="">Select Color</option>
                                @foreach($colors as $color)
                                    <option value="{{ $color->id }}" {{ old('color_id') == $color->id ? 'selected' : '' }}>{{ $color->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Order Quantity (Manual) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="order_quantity">Order Quantity</label>
                            <input type="number" name="order_quantity" id="order_quantity" class="form-control" value="{{ old('order_quantity') }}" placeholder="Enter Order Quantity" required min="1">
                        </div>
                    </div>

                    {{-- Target Price (Manual) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="target_price">Target Price</label>
                            <input type="number" step="0.01" name="target_price" id="target_price" class="form-control" value="{{ old('target_price') }}" placeholder="Enter Target Price" min="0">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Fabric Details</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    {{-- Fabric Composition (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="fabric_composition_id">Fabric Composition</label>
                            <select name="fabric_composition_id" id="fabric_composition_id" class="form-control" required>
                                <option value="">Select Fabric Composition</option>
                                @foreach($fabricCompositions as $composition)
                                    <option value="{{ $composition->id }}" {{ old('fabric_composition_id') == $composition->id ? 'selected' : '' }}>{{ $composition->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Fabric Type (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="fabric_type_id">Fabric Type</label>
                            <select name="fabric_type_id" id="fabric_type_id" class="form-control" required>
                                <option value="">Select Fabric Type</option>
                                @foreach($fabricTypes as $type)
                                    <option value="{{ $type->id }}" {{ old('fabric_type_id') == $type->id ? 'selected' : '' }}>{{ $type->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Yarn Count (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="yarn_count_id">Yarn Count</label>
                            <select name="yarn_count_id" id="yarn_count_id" class="form-control" required>
                                <option value="">Select Yarn Count</option>
                                @foreach($yarnCounts as $count)
                                    <option value="{{ $count->id }}" {{ old('yarn_count_id') == $count->id ? 'selected' : '' }}>{{ $count->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Fabric Weight (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="fabric_weight_id">Fabric Weight/GSM</label>
                            <select name="fabric_weight_id" id="fabric_weight_id" class="form-control" required>
                                <option value="">Select Fabric Weight</option>
                                @foreach($fabricWeights as $weight)
                                    <option value="{{ $weight->id }}" {{ old('fabric_weight_id') == $weight->id ? 'selected' : '' }}>{{ $weight->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Shipping Details</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    {{-- Shipment Date (Manual) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="shipment_date">Shipment Date</label>
                            <input type="date" name="shipment_date" id="shipment_date" class="form-control" value="{{ old('shipment_date') }}" required>
                        </div>
                    </div>

                    {{-- Port of Loading (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="port_of_landing_id">Port of Loading</label>
                            <select name="port_of_landing_id" id="port_of_landing_id" class="form-control" required>
                                <option value="">Select Port of Loading</option>
                                @foreach($portOfLandings as $port)
                                    <option value="{{ $port->id }}" {{ old('port_of_landing_id') == $port->id ? 'selected' : '' }}>{{ $port->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Country of Origin (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="country_of_origin_id">Country of Origin</label>
                            <select name="country_of_origin_id" id="country_of_origin_id" class="form-control" required>
                                <option value="">Select Country of Origin</option>
                                @foreach($countryOfOrigins as $country)
                                    <option value="{{ $country->id }}" {{ old('country_of_origin_id') == $country->id ? 'selected' : '' }}>{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Port of Discharge (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="port_of_discharge_id">Port of Discharge</label>
                            <select name="port_of_discharge_id" id="port_of_discharge_id" class="form-control" required>
                                <option value="">Select Port of Discharge</option>
                                @foreach($portOfDischarges as $port)
                                    <option value="{{ $port->id }}" {{ old('port_of_discharge_id') == $port->id ? 'selected' : '' }}>{{ $port->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Final Destination (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="final_destination_id">Final Destination</label>
                            <select name="final_destination_id" id="final_destination_id" class="form-control" required>
                                <option value="">Select Final Destination</option>
                                @foreach($finalDestinations as $destination)
                                    <option value="{{ $destination->id }}" {{ old('final_destination_id') == $destination->id ? 'selected' : '' }}>{{ $destination->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Delivery Term (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="delivery_term_id">Delivery Term</label>
                            <select name="delivery_term_id" id="delivery_term_id" class="form-control" required>
                                <option value="">Select Delivery Term</option>
                                @foreach($deliveryTerms as $term)
                                    <option value="{{ $term->id }}" {{ old('delivery_term_id') == $term->id ? 'selected' : '' }}>{{ $term->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- Shipment Mode (Dropdown) --}}
                    <div class="col-md-6 mb-3">
                        <div class="form-group">
                            <label for="shipment_mode_id">Shipment Mode</label>
                            <select name="shipment_mode_id" id="shipment_mode_id" class="form-control" required>
                                <option value="">Select Shipment Mode</option>
                                @foreach($shipmentModes as $mode)
                                    <option value="{{ $mode->id }}" {{ old('shipment_mode_id') == $mode->id ? 'selected' : '' }}>{{ $mode->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>


  <div class="col-md-6 mb-3">
                        <div class="form-group">
                      <div class="form-group">
    <label for="images">Upload Item Images</label>
    <input type="file" name="images"  class="form-control">
</div>

                    </div>

                </div>
            </div>
        </div>

     

        <div class="form-group p-2">
            <button type="submit" class="btn btn-primary"><i class="fas fa-check"></i> Submit Inquiry</button>
            <a href="{{ route('admin.inquiries.index') }}" class="btn btn-secondary"><i class="fas fa-times"></i> Cancel</a>
        </div>
    </form>
</div>
@include('admin.footer') 
