@include('admin.header')

<style>
    label {
        font-weight: 700;
    }
</style>

<div class="container bg-white p-3">
    <div class="row mb-3">
        <div class="col-md-6">
            <h1>Create Garment Add-on</h1>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('admin.garment_addons.index') }}" class="btn btn-secondary mb-3">
                <i class="fas fa-arrow-left"></i> Back to Add-ons
            </a>
        </div>
    </div>

    <form action="{{ route('admin.garment_addons.store') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label for="name" class="form-label">Name</label>
            <input type="text" class="form-control" id="name" name="name"  placeholder="Enter Name" required>
        </div>
        <div class="mb-3">
            <label for="consumption" class="form-label">Consumption</label>
            <input type="number" step="0.0001" class="form-control" id="consumption" placeholder="Enter Consumption" name="consumption" required>
        </div>
        <div class="mb-3">
            <label for="unit" class="form-label">Unit</label>
            <input type="text" class="form-control" id="unit" name="unit"  placeholder="Enter Unit" required>
        </div>
        <div class="mb-3">
            <label for="garment_type" class="form-label">Garment Type</label>
            <select class="form-control" id="garment_type" name="garment_type" required>
                <option value="top">Top</option>
                <option value="bottom">Bottom</option>
                <option value="both">Both</option>
            </select>
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea class="form-control" id="description" name="description" placeholder="Enter Description"></textarea>
        </div>
        <div class="mb-3 form-check">
            <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" checked>
            <label class="form-check-label" for="is_active">Active</label>
        </div>
        <button type="submit" class="btn btn-primary">Submit</button>
    </form>
</div>

@include('admin.footer')
