@include('admin.header') 

<div class="container">
           <div class="row mb-3">
            <div class="col-md-6">
    <h1>Fabric Add-ons</h1>

            </div>
            <div class="col-md-6 text-right">
                    <a href="{{ route('admin.fabric_addons.create') }}" class="btn btn-primary mb-3"><i class="fas fa-plus"></i> Add New Fabric Add-on</a>


            </div>
</div>
    @if (session("success"))
        <div class="alert alert-success">{{ session("success") }}</div>
    @endif
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
    <table class="table table-bordered">
        <thead class="text-white bg-dark">
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Price (USD/kg)</th>
                <th>Active</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($fabricAddons as $fabricAddon)
                <tr>
                    <td>{{ $fabricAddon->id }}</td>
                    <td>{{ $fabricAddon->name }}</td>
                    <td>{{ $fabricAddon->price }}</td>
                    <td>{{ $fabricAddon->is_active ? "Yes" : "No" }}</td>
                    <td>
                      
                        <a href="{{ route('admin.fabric_addons.edit', $fabricAddon->id) }}" class="btn btn-primary btn-sm"><i class="fas fa-edit"></i> Update</a>
                        <form action="{{ route('admin.fabric_addons.destroy', $fabricAddon->id) }}" method="POST" style="display:inline-block;">
                            @csrf
                            @method("DELETE")
                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')"><i class="fas fa-trash"></i> Remove</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
</div>
</div>

</div>
@include('admin.footer') 


