@include('admin.header')

<style>
    label {
        font-weight: 700;
    }
</style>

<div class="container bg-white p-3">
    <h1>Edit Garment Add-on</h1>
    <form action="{{ route('admin.garment_addons.update', $garmentAddon->id) }}" method="POST">
        @csrf
        @method("PUT")
        <div class="mb-3">
            <label for="name" class="form-label">Name</label>
            <input type="text" class="form-control" id="name" name="name" value="{{ $garmentAddon->name }}" required>
        </div>
        <div class="mb-3">
            <label for="consumption" class="form-label">Consumption</label>
            <input type="number" step="0.0001" class="form-control" id="consumption" name="consumption" value="{{ $garmentAddon->consumption }}" required>
        </div>
        <div class="mb-3">
            <label for="unit" class="form-label">Unit</label>
            <input type="text" class="form-control" id="unit" name="unit" value="{{ $garmentAddon->unit }}" required>
        </div>
        <div class="mb-3">
            <label for="garment_type" class="form-label">Garment Type</label>
            <select class="form-control" id="garment_type" name="garment_type" required>
                <option value="top" {{ $garmentAddon->garment_type == "top" ? "selected" : "" }}>Top</option>
                <option value="bottom" {{ $garmentAddon->garment_type == "bottom" ? "selected" : "" }}>Bottom</option>
                <option value="both" {{ $garmentAddon->garment_type == "both" ? "selected" : "" }}>Both</option>
            </select>
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea class="form-control" id="description" name="description">{{ $garmentAddon->description }}</textarea>
        </div>
        <div class="mb-3 form-check">
            <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" {{ $garmentAddon->is_active ? "checked" : "" }}>
            <label class="form-check-label" for="is_active">Active</label>
        </div>
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ route('admin.garment_addons.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@include('admin.footer')


