@include('admin.header') 

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Costs Management</h4>
                    <a href="{{ route('admin.costs.create') }}" class="btn btn-primary">Add New Cost</a>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Amount</th>
                                    <th>Category</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($costs as $cost)
                                    <tr>
                                        <td>{{ $cost->id }}</td>
                                        <td>{{ $cost->name }}</td>
                                        <td>${{ number_format($cost->amount, 2) }}</td>
                                        <td>{{ $cost->otherCost->name }}</td>
                                        <td>{{ $cost->created_at->format('d M Y') }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('admin.costs.show', $cost) }}" class="btn btn-info btn-sm">View</a>
                                                <a href="{{ route('admin.costs.edit', $cost) }}" class="btn btn-warning btn-sm">Edit</a>
                                                <form action="{{ route('admin.costs.destroy', $cost) }}" method="POST" style="display: inline-block;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this cost?')">Delete</button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center">No costs found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        {{ $costs->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('admin.footer') 

