@include('admin.header') 

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>Edit Cost</h4>
                    <a href="{{ route('admin.costs.index') }}" class="btn btn-secondary">Back to List</a>
                </div>

                <div class="card-body">
                    <form action="{{ route('admin.costs.update', $cost) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="mb-3">
                            <label for="name" class="form-label">Cost Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                   id="name" name="name" value="{{ old('name', $cost->name) }}" required>
                            @error('name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="amount" class="form-label">Amount <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" class="form-control @error('amount') is-invalid @enderror" 
                                   id="amount" name="amount" value="{{ old('amount', $cost->amount) }}" required>
                            @error('amount')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="other_cost_id" class="form-label">Category <span class="text-danger">*</span></label>
                            <select class="form-select form-control @error('other_cost_id') is-invalid @enderror" 
                                    id="other_cost_id" name="other_cost_id" required>
                                <option value="">Select Category</option>
                                @foreach ($otherCosts as $otherCost)
                                    <option value="{{ $otherCost->id }}" 
                                        {{ old('other_cost_id', $cost->other_cost_id) == $otherCost->id ? 'selected' : '' }}>
                                        {{ $otherCost->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('other_cost_id')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                            <a href="{{ route('admin.costs.index') }}" class="btn btn-secondary me-md-2">Cancel</a>
                            <button type="submit" class="btn btn-primary" style="margin-left: 10px;">Update Cost</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@include('admin.footer') 


